<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

	class IPThermostatGroup
	{
		// Properties
		public $ID;
		public $Name;
		public $Description;

		// Constructor
		public function __construct()
		{
			$numargs = func_num_args();
			$args = func_get_args();

			switch ($numargs)
			{
				case 2:

					$this->ID = $args[0];

					if ($args[1] === true)
					{
						$this->Load();
					}

					break;

				case 3:

					$this->ID = $args[0];
					$this->Name = $args[1];
					$this->Description = $args[2];

					break;

				default:

					$this->ID = -1;
					$this->Name = '';
					$this->Description = '';

					break;
			}
		}


		// Methods
		private function Load()
		{
			$dataAccess = new MySqlDataAccess(Common::ConnectionString);
			$dataAccess->Command->CommandType = CommandType::StoredProcedure;
			$dataAccess->Command->CommandText = "CALL sp_ThermostatGroup_Load_Details($this->ID)";
			$dataAccess->GetData();

			$row = $dataAccess->ResultSet->fetch_assoc();

			$this->Name = $row['Name'];
			$this->Description = $row['Description'];

			$dataAccess->Cleanup();
		}
	}

?>
