/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.VerilogModel;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerilogParser {
    private List modules = new ArrayList();
    private BufferedReader fin = null;

    public List getModules() {
        return this.modules;
    }

    public boolean parse(String verilogFile) {
        try {
            FileReader reader = new FileReader(verilogFile);
            this.fin = new BufferedReader(reader);
        }
        catch (IOException e) {
            System.out.println("Failed to open file for read: " + verilogFile + ": " + e.getMessage());
        }
        if (this.fin == null) {
            return false;
        }
        StreamTokenizer st = new StreamTokenizer(this.fin);
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.wordChars(95, 95);
        try {
            int token = st.nextToken();
            while (token != -1) {
                switch (token) {
                    case -3: {
                        if (st.sval.equals("module")) {
                            if (this.parseModule(st)) break;
                            return false;
                        }
                        if (st.sval.equals("primitive")) {
                            if (this.parsePrimitive(st)) break;
                            return false;
                        }
                        this.error(st, "expected module/primitive definition");
                        break;
                    }
                    case 96: {
                        st.nextToken();
                        if (st.sval.equals("include")) {
                            st.nextToken();
                            break;
                        }
                        if (st.sval.equals("define")) {
                            st.nextToken();
                            st.nextToken();
                            break;
                        }
                        this.error(st, "expected valid defintion after `");
                        break;
                    }
                    default: {
                        this.error(st, "expected word");
                    }
                }
                token = st.nextToken();
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean parseModule(StreamTokenizer st) {
        try {
            int token = st.nextToken();
            if (token != -3) {
                this.error(st, "expected module name");
                return false;
            }
            Module module = new Module(st.sval);
            this.expect(st, 40);
            while (token != 41) {
                token = st.nextToken();
            }
            this.expect(st, 59);
            boolean processPorts = true;
            while (processPorts) {
                token = st.nextToken();
                switch (token) {
                    case -3: {
                        if (st.sval.equalsIgnoreCase("input")) {
                            this.parsePorts(st, 0, module);
                            break;
                        }
                        if (st.sval.equalsIgnoreCase("output")) {
                            this.parsePorts(st, 1, module);
                            break;
                        }
                        if (st.sval.equalsIgnoreCase("inout")) {
                            this.parsePorts(st, 2, module);
                            break;
                        }
                        processPorts = false;
                        st.pushBack();
                    }
                }
            }
            while (!((token = st.nextToken()) == -1 || token == -3 && st.sval.equals("endmodule"))) {
            }
            this.modules.add(module);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean parsePrimitive(StreamTokenizer st) {
        try {
            int token;
            while (!((token = st.nextToken()) == -1 || token == -3 && st.sval.equals("endprimitive"))) {
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    private void parsePorts(StreamTokenizer st, int type, Module module) {
        try {
            int token;
            while ((token = st.nextToken()) != 59) {
                if (token == 44) continue;
                String name = st.sval;
                int start = 1;
                int end = 1;
                boolean quoted = false;
                if (token == 91) {
                    st.nextToken();
                    start = (int)st.nval;
                    this.expect(st, 58);
                    st.nextToken();
                    end = (int)st.nval;
                    this.expect(st, 93);
                    token = st.nextToken();
                    name = st.sval;
                }
                if (token == 92) {
                    StringBuffer buf = new StringBuffer("\\");
                    st.ordinaryChar(32);
                    while ((token = st.nextToken()) != 32) {
                        if (token == -3) {
                            buf.append(st.sval);
                            continue;
                        }
                        if (token == -2) {
                            buf.append((int)st.nval);
                            continue;
                        }
                        buf.append((char)token);
                    }
                    st.whitespaceChars(32, 32);
                    buf.append(" ");
                    name = buf.toString();
                    quoted = true;
                }
                module.addPort(new Port(name, type, start, end, quoted));
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private boolean expect(StreamTokenizer st, int nextToken) {
        try {
            int token = st.nextToken();
            if (token != nextToken) {
                this.error(st, "expected " + (char)nextToken);
                return false;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    private void error(StreamTokenizer st, String msg) {
        System.out.print("Parse error on token ");
        switch (st.ttype) {
            case -3: {
                System.out.print("\"" + st.sval + "\"");
            }
            case -2: {
                System.out.print("\"" + st.nval + "\"");
            }
            case -1: {
                System.out.print("EOF");
            }
            case 10: {
                System.out.print("EOL");
            }
        }
        System.out.print("\"" + (char)st.ttype + "\"");
        System.out.println(", line " + st.lineno() + ": " + msg);
    }

    public static void main(String[] args) {
        VerilogParser vp = new VerilogParser();
        if (!vp.parse(VerilogModel.getExampleVerilogChipFile())) {
            System.out.println("Parsing failed.");
            return;
        }
        System.out.println("Parsing succeeded: modules are:");
        for (Module m : vp.getModules()) {
            System.out.println(m.print());
        }
    }

    public static final class Module {
        public final String name;
        private final List inports;
        private final List outports;
        private final List inoutports;

        public Module(String name) {
            this.name = name;
            this.inports = new ArrayList();
            this.outports = new ArrayList();
            this.inoutports = new ArrayList();
        }

        void addPort(Port port) {
            if (port.type == 0) {
                this.inports.add(port);
            } else if (port.type == 1) {
                this.outports.add(port);
            } else if (port.type == 2) {
                this.inoutports.add(port);
            } else {
                System.out.println("Unknown port type (" + port.type + ") for port " + port.name);
            }
        }

        List getInports() {
            return this.inports;
        }

        List getOutports() {
            return this.outports;
        }

        List getInoutports() {
            return this.inoutports;
        }

        List getPorts() {
            ArrayList ports = new ArrayList();
            ports.addAll(this.inports);
            ports.addAll(this.outports);
            ports.addAll(this.inoutports);
            return ports;
        }

        StringBuffer print() {
            StringBuffer buf = new StringBuffer();
            buf.append("module " + this.name);
            buf.append(this.printPorts(null));
            return buf;
        }

        StringBuffer printPorts(VerilogModel.AllAliasedNames aliased) {
            StringBuffer buf = new StringBuffer();
            int lineno = 0;
            buf.append("(");
            Iterator it = this.getPorts().iterator();
            while (it.hasNext()) {
                Port p = (Port)it.next();
                String alias = p.name;
                if (aliased != null) {
                    alias = aliased.getAliasFor(alias);
                }
                buf.append("." + p.name + "(" + alias + ")");
                if (it.hasNext()) {
                    buf.append(", ");
                }
                if (buf.length() / 60 <= lineno) continue;
                buf.append("\n\t");
                ++lineno;
            }
            buf.append(");\n");
            return buf;
        }
    }

    public static final class Port {
        public final String name;
        public final int type;
        public final int start;
        public final int end;
        public final boolean containsSpecialChars;
        public static final int INPUT = 0;
        public static final int OUTPUT = 1;
        public static final int INOUT = 2;
        private static final Pattern bussedSig = Pattern.compile("(\\w+)\\[(\\d+)\\]");

        public Port(String name, int type, int start, int end, boolean containsSpecialChars) {
            this.name = name;
            this.type = type;
            this.start = start;
            this.end = end;
            this.containsSpecialChars = containsSpecialChars;
        }

        public Port(String name, int type) {
            this(name, type, 1, 1, false);
        }

        public boolean contains(String name) {
            if (name.equals(this.name)) {
                return true;
            }
            Matcher m = bussedSig.matcher(name);
            if (this.start != this.end && m.matches()) {
                String n = m.group(1);
                int idx = Integer.parseInt(m.group(2));
                if (n.equals(this.name) && idx >= this.start && idx <= this.end) {
                    return true;
                }
            }
            return false;
        }
    }
}

