/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.Poly3D;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.plugins.j3d.J3DKeyCollision;
import com.sun.electric.plugins.j3d.utils.J3DAppearance;
import com.sun.electric.plugins.j3d.utils.J3DAxis;
import com.sun.electric.plugins.j3d.utils.J3DCanvas3D;
import com.sun.electric.plugins.j3d.utils.J3DUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.AbstractFixpRectangle;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.tree.MutableTreeNode;
import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.Interpolator;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.View;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnElapsedFrames;
import org.jogamp.java3d.utils.behaviors.interpolators.KBKeyFrame;
import org.jogamp.java3d.utils.behaviors.interpolators.RotPosScaleTCBSplinePathInterpolator;
import org.jogamp.java3d.utils.behaviors.interpolators.TCBKeyFrame;
import org.jogamp.java3d.utils.behaviors.vp.OrbitBehavior;
import org.jogamp.java3d.utils.behaviors.vp.ViewPlatformBehavior;
import org.jogamp.java3d.utils.geometry.Primitive;
import org.jogamp.java3d.utils.picking.PickCanvas;
import org.jogamp.java3d.utils.picking.PickIntersection;
import org.jogamp.java3d.utils.picking.PickResult;
import org.jogamp.java3d.utils.universe.PlatformGeometry;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.java3d.utils.universe.ViewingPlatform;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Quat4f;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

public class View3DWindow
extends JPanel
implements WindowContent,
MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
ActionListener,
DatabaseChangeListener {
    private SimpleUniverse u;
    private J3DCanvas3D canvas;
    protected TransformGroup objTrans;
    private BranchGroup scene;
    private OrbitBehavior orbit;
    private Map<TransformGroup, Interpolator> interpolatorMap = new HashMap<TransformGroup, Interpolator>();
    private J3DKeyCollision keyBehavior;
    private WindowFrame wf;
    private EditWindow view2D;
    private LayerVisibility lv;
    private HashMap<Layer, J3DAppearance> layerAppearance = new HashMap();
    private Map<String, J3DAppearance> colorAppearance = new HashMap<String, J3DAppearance>();
    protected Cell cell;
    private double scale3D = J3DUtils.get3DFactor();
    private Highlighter highlighter;
    private PickCanvas pickCanvas;
    private Map<ElectricObject, List<Node>> electricObjectMap = new HashMap<ElectricObject, List<Node>>();
    private boolean oneTransformPerNode = false;
    private Map<Node, TransformGroup> transformGroupMap = new HashMap<Node, TransformGroup>();
    private boolean reachLimit = false;
    private boolean alreadyChecked = false;
    private Job job;
    private int maxNumNodes;
    private boolean locosShape;
    private static Vector3d tmpVec = new Vector3d();
    private static Vector3d mapSize = null;

    public static void show3DPolygons(ArrayList<PolyBase> polys) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        WindowContent view2D = wf.getContent();
        Cell cell = view2D.getCell();
        new View3DWindowJob(cell, polys, wf, view2D, false);
    }

    public static void create3DWindow(Cell cell, WindowFrame wf, WindowContent view2D, boolean transPerNode) {
        new View3DWindowJob(cell, null, wf, view2D, transPerNode);
    }

    public void getObjTransform(Transform3D trans) {
        this.objTrans.getTransform(trans);
    }

    public void setObjTransform(Transform3D trans) {
        this.objTrans.setTransform(trans);
    }

    private boolean isSizeLimitOK(int number) {
        if (this.reachLimit || number > this.maxNumNodes) {
            if (!this.alreadyChecked) {
                String[] possibleValues = new String[]{"Full", "Limit", "Cancel"};
                int response = Job.getUserInterface().askForChoice("Number of nodes in graph scene reached limit of " + this.maxNumNodes + " (loaded " + number + " nodes so far).\nClick 'Full' to include all nodes in " + this.cell + ", 'Limit' to show " + number + " nodes or 'Cancel' to abort process.\nUnexpand cells to reduce the number).", "Warning", possibleValues, possibleValues[2]);
                this.alreadyChecked = true;
                if (response > 0) {
                    if (response == 2) {
                        this.job.abort();
                    }
                    this.reachLimit = true;
                }
            }
            if (this.reachLimit) {
                return false;
            }
        }
        return true;
    }

    View3DWindow(Cell cell, List<PolyBase> overridePolygons, WindowFrame wf, WindowContent view2D, boolean transPerNode, Job job) {
        this.cell = cell;
        this.wf = wf;
        this.view2D = (EditWindow)view2D;
        this.lv = this.view2D.getLayerVisibility();
        this.oneTransformPerNode = transPerNode;
        this.job = job;
        this.maxNumNodes = J3DUtils.get3DMaxNumNodes();
        this.highlighter = new Highlighter(0, wf);
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        if (config == null) {
            GraphicsConfigTemplate3D gc3D = new GraphicsConfigTemplate3D();
            gc3D.setSceneAntialiasing(2);
            GraphicsDevice[] gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            config = gd[0].getBestConfiguration((GraphicsConfigTemplate)gc3D);
        }
        this.canvas = new J3DCanvas3D(config);
        this.add("Center", (Component)((Object)this.canvas));
        this.canvas.addMouseListener(this);
        J3DAppearance.setCellAppearanceValues(this);
        J3DAppearance.setHighlightedAppearanceValues(this);
        J3DAppearance.setAxisAppearanceValues(this);
        J3DUtils.setAlpha(J3DUtils.get3DAlpha());
        this.scene = this.createSceneGraph(cell, overridePolygons);
        if (this.scene == null) {
            return;
        }
        this.scene.compile();
        this.u = new SimpleUniverse((Canvas3D)this.canvas);
        PlatformGeometry pg = new PlatformGeometry();
        J3DUtils.createLights((BranchGroup)pg);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        this.orbit = new OrbitBehavior((Canvas3D)this.canvas, 112);
        this.orbit.setSchedulingBounds((Bounds)J3DUtils.infiniteBounds);
        this.orbit.setCapability(11);
        Point3d center = new Point3d(0.0, 0.0, 0.0);
        BoundingSphere sceneBnd = (BoundingSphere)this.scene.getBounds();
        sceneBnd.getCenter(center);
        this.orbit.setRotationCenter(center);
        this.orbit.setMinRadius(0.0);
        this.orbit.setProportionalZoom(true);
        viewingPlatform.setNominalViewingTransform();
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)this.orbit);
        double radius = sceneBnd.getRadius();
        View view = this.u.getViewer().getView();
        if (this.canvas.getSceneAntialiasingAvailable() && J3DUtils.is3DAntialiasing()) {
            view.setSceneAntialiasingEnable(true);
        }
        view.setProjectionPolicy(J3DUtils.is3DPerspective() ? 1 : 0);
        if (!J3DUtils.is3DPerspective()) {
            view.setCompatibilityModeEnable(true);
        }
        view.setTransparencySortingPolicy(1);
        view.setDepthBufferFreezeTransparent(false);
        Vector3d vCenter = new Vector3d((Tuple3d)center);
        double vDist = 1.4 * radius / Math.tan(view.getFieldOfView() / 2.0);
        vCenter.z += vDist;
        Transform3D vTrans = new Transform3D();
        vTrans.setTranslation(vCenter);
        view.setBackClipDistance((vDist + radius) * 200.0);
        view.setFrontClipDistance((vDist + radius) / 200.0);
        if (J3DUtils.is3DPerspective()) {
            viewingPlatform.getViewPlatformBehavior().setHomeTransform(vTrans);
            viewingPlatform.getViewPlatformBehavior().goHome();
        } else {
            Transform3D proj = new Transform3D();
            ERectangle cellBnd = cell.getBounds();
            proj.ortho(((RectangularShape)cellBnd).getMinX(), ((RectangularShape)cellBnd).getMinX(), ((RectangularShape)cellBnd).getMinY(), ((RectangularShape)cellBnd).getMaxY(), (vDist + radius) / 200.0, (vDist + radius) * 2.0);
            view.setVpcToEc(proj);
        }
        this.u.addBranchGraph(this.scene);
        BranchGroup axisRoot = new BranchGroup();
        Transform3D t = new Transform3D();
        t.set(new Vector3d(-radius / 10.0, -radius / 16.0, -radius / 3.5));
        TransformGroup axisTranslation = new TransformGroup(t);
        axisRoot.addChild((Node)axisTranslation);
        final TransformGroup axisTG = new TransformGroup();
        axisTG.setCapability(18);
        axisTG.setCapability(17);
        axisTranslation.addChild((Node)axisTG);
        J3DAxis axis = new J3DAxis(radius / 10.0, J3DAppearance.axisApps[0], J3DAppearance.axisApps[1], J3DAppearance.axisApps[2], User.getDefaultFont());
        axisTG.addChild((Node)axis);
        pg.addChild((Node)axisRoot);
        final TransformGroup viewPlatformTG = viewingPlatform.getViewPlatformTransform();
        pg.addChild((Node)new Behavior(){

            public void initialize() {
                this.setSchedulingInterval(Behavior.getNumSchedulingIntervals() - 1);
                this.setSchedulingBounds((Bounds)J3DUtils.infiniteBounds);
                this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(0, true));
            }

            public void processStimulus(Iterator<WakeupCriterion> arg0) {
                Transform3D t = new Transform3D();
                viewPlatformTG.getTransform(t);
                t.setTranslation(new Vector3d());
                t.invert();
                axisTG.setTransform(t);
                this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(0, true));
            }
        });
        viewingPlatform.setPlatformGeometry(pg);
        this.setWindowTitle();
        UserInterfaceMain.addDatabaseChangeListener(this);
    }

    protected BranchGroup createSceneGraph(Cell cell, List<PolyBase> overridePolygons) {
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(3);
        objRoot.setCapability(1);
        objRoot.setCapability(4);
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.7);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        this.objTrans = new TransformGroup();
        this.objTrans.setCapability(18);
        this.objTrans.setCapability(17);
        this.objTrans.setCapability(1);
        this.objTrans.setCapability(14);
        this.objTrans.setCapability(12);
        this.objTrans.setCapability(13);
        this.objTrans.setCapability(3);
        objScale.addChild((Node)this.objTrans);
        J3DUtils.createBackground(objRoot);
        if (overridePolygons == null) {
            View3DEnumerator view3D = new View3DEnumerator(cell);
            HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)view3D);
            if (this.electricObjectMap.isEmpty()) {
                System.out.println("No 3D elements added. Check 3D values.");
            }
        } else {
            block6: for (PolyBase poly : overridePolygons) {
                J3DAppearance ap;
                double distance = 0.0;
                double thickness = 0.0;
                Color color = null;
                String text = null;
                float transparency = 0.0f;
                if (poly instanceof Poly3D) {
                    Poly3D p3d = (Poly3D)poly;
                    distance = p3d.getLowZ() * this.scale3D;
                    thickness = (p3d.getHighZ() - p3d.getLowZ()) * this.scale3D;
                    color = p3d.getColor();
                    transparency = p3d.getTransparency();
                    text = p3d.getText();
                }
                if (color == null) {
                    Layer layer = poly.getLayer();
                    if (layer == null || layer.getTechnology() == null || !this.lv.isVisible(layer) || (thickness = layer.getThickness() * this.scale3D) == 0.0) continue;
                    distance = layer.getDistance() * this.scale3D;
                    EGraphics graphics = layer.getGraphics();
                    color = graphics.getColor();
                    ap = this.getAppearance(color, 0.1f);
                } else {
                    ap = this.getAppearance(color, transparency);
                }
                Poly.Type type = poly.getStyle();
                PolyBase.Point[] points = poly.getPoints();
                switch (type) {
                    case OPENED: {
                        Point3d[] pts;
                        if (points.length == 1) {
                            pts = new Point3d[]{new Point3d(((Point2D)points[0]).getX(), ((Point2D)points[0]).getY(), distance), new Point3d(((Point2D)points[0]).getX(), ((Point2D)points[0]).getY(), distance + thickness)};
                        } else {
                            pts = new Point3d[points.length];
                            for (int i = 0; i < points.length; ++i) {
                                pts[i] = new Point3d(((Point2D)points[i]).getX(), ((Point2D)points[i]).getY(), distance);
                            }
                        }
                        J3DUtils.addLine3D(pts, ap, this.objTrans);
                        continue block6;
                    }
                    case FILLED: 
                    case CLOSED: {
                        if (poly.getBox() == null) {
                            J3DUtils.addPolyhedron(poly.getPathIterator(null), distance, thickness, (Appearance)ap, this.objTrans);
                            continue block6;
                        }
                        FixpRectangle bounds = poly.getBounds2D();
                        J3DUtils.addPolyhedron(bounds, distance, thickness, (Appearance)ap, this.objTrans);
                        continue block6;
                    }
                    case CIRCLE: 
                    case DISC: {
                        J3DUtils.addCylinder(poly.getPoints(), distance, thickness, ap, this.objTrans);
                        continue block6;
                    }
                    case TEXTCENT: {
                        J3DUtils.addText(text, ((Point2D)points[0]).getX(), ((Point2D)points[0]).getY(), distance, ap, this.objTrans);
                        continue block6;
                    }
                }
                if (!Job.getDebug()) continue;
                System.out.println("Case not implemented in View3DDWindow.addPolys type='" + type + "'");
            }
        }
        if (this.job.checkAbort()) {
            return null;
        }
        this.pickCanvas = new PickCanvas((Canvas3D)this.canvas, objRoot);
        this.pickCanvas.setMode(1024);
        this.pickCanvas.setTolerance(4.0f);
        this.setInterpolator();
        this.keyBehavior = new J3DKeyCollision(this.objTrans, this);
        this.keyBehavior.setSchedulingBounds((Bounds)J3DUtils.infiniteBounds);
        this.objTrans.addChild((Node)this.keyBehavior);
        return objRoot;
    }

    @Override
    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        this.wf.setTitle(this.wf.composeTitle(this.cell, "3D View: ", 0));
    }

    @Override
    public Cell getCell() {
        return this.cell;
    }

    @Override
    public void finished() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
        UserInterfaceMain.removeDatabaseChangeListener(this);
    }

    @Override
    public void bottomScrollChanged(int e) {
    }

    @Override
    public void rightScrollChanged(int e) {
    }

    @Override
    public void fullRepaint() {
        J3DUtils.setBackgroundColor(null);
        J3DAppearance.setCellAppearanceValues(null);
        J3DAppearance.setHighlightedAppearanceValues(null);
        J3DUtils.setAmbientalColor(null);
        J3DAppearance.setAxisAppearanceValues(null);
        J3DUtils.setDirectionalColor(null);
        for (Map.Entry<Layer, J3DAppearance> e : this.layerAppearance.entrySet()) {
            Layer layer = e.getKey();
            J3DAppearance app = e.getValue();
            app.setGraphics(layer.getGraphics());
        }
        this.repaint();
    }

    @Override
    public boolean findNextText(boolean reverse) {
        return false;
    }

    @Override
    public void replaceText(String replace) {
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set<TextUtils.WhatToSearch> whatToSearch, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr, boolean highlightedOnly) {
    }

    @Override
    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
        Cell cell = this.getCell();
        if (cell == null) {
            return;
        }
        double panningAmount = panningAmounts[User.getPanningDistance()];
        int mult = (int)(10.0 * panningAmount);
        if (mult == 0) {
            mult = 1;
        }
        this.keyBehavior.moveAlongAxis(direction, mult * ticks);
    }

    @Override
    public void centerCursor() {
    }

    @Override
    public void zoomOutContents() {
        this.keyBehavior.zoomInOut(false);
    }

    @Override
    public void zoomInContents() {
        this.keyBehavior.zoomInOut(true);
    }

    @Override
    public void fillScreen() {
        this.objTrans.setTransform(new Transform3D());
        this.u.getViewingPlatform().getViewPlatformBehavior().goHome();
    }

    @Override
    public void setCell(Cell cell, VarContext context, WindowFrame.DisplayAttributes da) {
    }

    @Override
    public void focusOnHighlighted() {
    }

    @Override
    public void replaceAllText(String replace) {
    }

    @Override
    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    @Override
    public List<MutableTreeNode> loadExplorerTrees() {
        return this.wf.loadDefaultExplorerTree();
    }

    @Override
    public void loadTechnologies() {
        this.lv = LayerVisibility.getLayerVisibility();
    }

    public void addArc(ArcInst ai, FixpTransform transform, TransformGroup objTrans) {
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        List<Node> list = this.addPolys(tech.getShapeOfArc(ai), transform, objTrans);
        if (list.isEmpty()) {
            System.out.println("Zero width arc or no layer with non-zero thickness found in arc '" + ai.getName() + "'");
        } else {
            this.electricObjectMap.put(ai, list);
        }
    }

    private void addNode(NodeInst no, FixpTransform transform, TransformGroup objTrans) {
        NodeProto nProto = no.getProto();
        Technology tech = nProto.getTechnology();
        int gate = -1;
        int count = 0;
        int poly = -1;
        if (NodeInst.isSpecialNode(no)) {
            return;
        }
        List<Node> list = null;
        if (no.isCellInstance()) {
            Cell cell = (Cell)nProto;
            AbstractFixpRectangle rect = no.getBounds();
            double[] values = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
            if (cell.getZValues(values)) {
                values[0] = values[0] * this.scale3D;
                values[1] = values[1] * this.scale3D;
                Poly pol = new Poly(rect);
                list = new ArrayList<Node>(1);
                if (transform.getType() != 0) {
                    pol.transform(transform);
                }
                rect = pol.getBounds2D();
                list.add((Node)J3DUtils.addPolyhedron(rect, values[0], values[1] - values[0], (Appearance)J3DAppearance.cellApp, objTrans));
            }
        } else {
            Poly[] polys = tech.getShapeOfNode(no, true, true, null);
            ArrayList<Shape3D> boxList = null;
            if (nProto.getFunction().isTransistor()) {
                int[] active = new int[2];
                boolean isSerpentine = no.isSerpentineTransistor();
                boolean isCBTransistor = no.getFunction().isCNTransistor();
                boxList = new ArrayList<Shape3D>(4);
                for (int i = 0; i < polys.length; ++i) {
                    Layer.Function fun = polys[i].getLayer().getFunction();
                    if (!isSerpentine && !isCBTransistor && fun.isDiff()) {
                        if (count > 1) {
                            System.out.println("More than 2 active regions detected in Transistor '" + no.getName() + "'. Ignoring this layer");
                            continue;
                        }
                        active[count++] = i;
                        continue;
                    }
                    if (fun.isGatePoly()) {
                        gate = i;
                        continue;
                    }
                    if (!fun.isPoly()) continue;
                    poly = i;
                }
                if (count == 2) {
                    FixpRectangle rect1 = polys[active[0]].getBounds2D();
                    FixpRectangle rect2 = polys[active[1]].getBounds2D();
                    double minX = Math.min(((RectangularShape)rect1).getMinX(), ((RectangularShape)rect2).getMinX());
                    double minY = Math.min(((RectangularShape)rect1).getMinY(), ((RectangularShape)rect2).getMinY());
                    double maxX = Math.max(((RectangularShape)rect1).getMaxX(), ((RectangularShape)rect2).getMaxX());
                    double maxY = Math.max(((RectangularShape)rect1).getMaxY(), ((RectangularShape)rect2).getMaxY());
                    Rectangle2D.Double newRect = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
                    Poly tmp = new Poly(newRect);
                    tmp.setLayer(polys[active[0]].getLayer());
                    polys[active[0]] = tmp;
                    int last = polys.length - 1;
                    if (active[1] != last) {
                        polys[active[1]] = polys[last];
                    }
                    polys[last] = null;
                }
            }
            list = this.addPolys(polys, transform, objTrans);
            if (this.locosShape && nProto.getFunction().isTransistor() && gate != -1 && poly != -1) {
                int right;
                int center;
                PolyBase.Point pointClose;
                PolyBase.Point pointDist;
                Point3d[] pts = new Point3d[8];
                PolyBase.Point[] points = polys[gate].getPoints();
                PolyBase.Point p0 = points[0];
                PolyBase.Point p1 = points[1];
                PolyBase.Point p2 = points[points.length - 1];
                double dist1 = ((Point2D)p0).distance(p1);
                double dist2 = ((Point2D)p0).distance(p2);
                Layer layer = polys[gate].getLayer();
                double dist = (layer.getDistance() + layer.getThickness()) * this.scale3D;
                double distPoly = polys[poly].getLayer().getDistance() * this.scale3D;
                ArrayList<Point3d> topList = new ArrayList<Point3d>();
                ArrayList<Point3d> bottomList = new ArrayList<Point3d>();
                if (dist1 > dist2) {
                    pointDist = p1;
                    pointClose = p2;
                    center = 1;
                    right = 2;
                } else {
                    pointDist = p2;
                    pointClose = p1;
                    center = 2;
                    right = points.length - 1;
                }
                Point2d pDelta = new Point2d(((Point2D)pointDist).getX() - ((Point2D)points[0]).getX(), ((Point2D)pointDist).getY() - ((Point2D)points[0]).getY());
                pDelta.scale(0.1);
                double[] values = new double[2];
                pDelta.get(values);
                topList.add(new Point3d(((Point2D)p0).getX() + values[0], ((Point2D)p0).getY() + values[1], dist));
                topList.add(new Point3d(((Point2D)p0).getX(), ((Point2D)p0).getY(), distPoly));
                topList.add(new Point3d(((Point2D)p0).getX() - values[0], ((Point2D)p0).getY() - values[1], distPoly));
                topList.add(new Point3d(((Point2D)p0).getX(), ((Point2D)p0).getY(), dist));
                bottomList.add(new Point3d(((Point2D)pointClose).getX() + values[0], ((Point2D)pointClose).getY() + values[1], dist));
                bottomList.add(new Point3d(((Point2D)pointClose).getX(), ((Point2D)pointClose).getY(), distPoly));
                bottomList.add(new Point3d(((Point2D)pointClose).getX() - values[0], ((Point2D)pointClose).getY() - values[1], distPoly));
                bottomList.add(new Point3d(((Point2D)pointClose).getX(), ((Point2D)pointClose).getY(), dist));
                J3DUtils.correctNormals(topList, bottomList);
                System.arraycopy(topList.toArray(), 0, pts, 0, 4);
                System.arraycopy(bottomList.toArray(), 0, pts, 4, 4);
                boxList.add(J3DUtils.addShape3D(pts, 4, this.getAppearance(layer), objTrans));
                topList.clear();
                bottomList.clear();
                topList.add(new Point3d(((Point2D)points[center]).getX() - values[0], ((Point2D)points[center]).getY() - values[1], dist));
                topList.add(new Point3d(((Point2D)points[center]).getX(), ((Point2D)points[center]).getY(), distPoly));
                topList.add(new Point3d(((Point2D)points[center]).getX() + values[0], ((Point2D)points[center]).getY() + values[1], distPoly));
                topList.add(new Point3d(((Point2D)points[center]).getX(), ((Point2D)points[center]).getY(), dist));
                bottomList.add(new Point3d(((Point2D)points[right]).getX() - values[0], ((Point2D)points[right]).getY() - values[1], dist));
                bottomList.add(new Point3d(((Point2D)points[right]).getX(), ((Point2D)points[right]).getY(), distPoly));
                bottomList.add(new Point3d(((Point2D)points[right]).getX() + values[0], ((Point2D)points[right]).getY() + values[1], distPoly));
                bottomList.add(new Point3d(((Point2D)points[right]).getX(), ((Point2D)points[right]).getY(), dist));
                J3DUtils.correctNormals(topList, bottomList);
                System.arraycopy(topList.toArray(), 0, pts, 0, 4);
                System.arraycopy(bottomList.toArray(), 0, pts, 4, 4);
                boxList.add(J3DUtils.addShape3D(pts, 4, this.getAppearance(layer), objTrans));
            }
            if (boxList != null) {
                list.addAll(boxList);
            }
        }
        if (list == null || list.isEmpty()) {
            System.out.println("Flat node or no layer with non-zero thickness found in node '" + no.getName() + "'");
        } else {
            this.electricObjectMap.put(no, list);
            for (int i = 0; i < list.size(); ++i) {
                this.transformGroupMap.put(list.get(i), objTrans);
            }
        }
    }

    private List<Node> addPolys(Poly[] polys, FixpTransform transform, TransformGroup objTrans) {
        if (polys == null) {
            return null;
        }
        ArrayList<Node> list = new ArrayList<Node>();
        block4: for (int i = 0; i < polys.length; ++i) {
            Layer layer;
            Poly poly = polys[i];
            if (poly == null || (layer = poly.getLayer()) == null || layer.getTechnology() == null || !this.lv.isVisible(layer)) continue;
            double thickness = layer.getThickness() * this.scale3D;
            double distance = layer.getDistance() * this.scale3D;
            if (thickness == 0.0) continue;
            if (transform != null) {
                poly.transform(transform);
            }
            J3DAppearance ap = this.getAppearance(layer);
            Poly.Type type = poly.getStyle();
            switch (type) {
                case FILLED: 
                case CLOSED: {
                    if (poly.getBox() == null) {
                        list.add((Node)J3DUtils.addPolyhedron(poly.getPathIterator(null), distance, thickness, (Appearance)ap, objTrans));
                        continue block4;
                    }
                    FixpRectangle bounds = poly.getBounds2D();
                    list.add((Node)J3DUtils.addPolyhedron(bounds, distance, thickness, (Appearance)ap, objTrans));
                    continue block4;
                }
                case CIRCLE: 
                case DISC: {
                    list.add(J3DUtils.addCylinder(poly.getPoints(), distance, thickness, ap, objTrans));
                    continue block4;
                }
                default: {
                    if (!Job.getDebug()) continue block4;
                    System.out.println("Case not implemented in View3DDWindow.addPolys type='" + type + "'");
                }
            }
        }
        return list;
    }

    private void selectObject(boolean toSelect, boolean do2D) {
        Highlighter highlighter2D = null;
        if (this.view2D != null && do2D) {
            highlighter2D = this.view2D.getHighlighter();
            highlighter2D.clear();
        }
        for (Highlight h : this.highlighter.getHighlights()) {
            HighlightShape3D hObj = (HighlightShape3D)h.getObject();
            if (hObj == null) continue;
            if (toSelect) {
                hObj.setAppearance(J3DAppearance.highlightApp);
                if (this.view2D == null || !do2D) continue;
                BoundingBox bb = (BoundingBox)hObj.shape.getBounds();
                Point3d lowerP = new Point3d();
                Point3d upperP = new Point3d();
                bb.getUpper(upperP);
                bb.getLower(lowerP);
                double[] lowerValues = new double[3];
                double[] upperValues = new double[3];
                lowerP.get(lowerValues);
                upperP.get(upperValues);
                Rectangle2D.Double area = new Rectangle2D.Double(lowerValues[0], lowerValues[1], upperValues[0] - lowerValues[0], upperValues[1] - lowerValues[1]);
                highlighter2D.addArea(area, this.cell);
                continue;
            }
            if (hObj.origApp != null) {
                hObj.setAppearance(hObj.origApp);
                continue;
            }
            hObj.setAppearance(J3DAppearance.cellApp);
        }
        if (!toSelect) {
            this.highlighter.clear();
        }
        if (do2D) {
            this.view2D.fullRepaint();
        }
    }

    public static void setScaleFactor(double value) {
        Transform3D vTrans = new Transform3D();
        Vector3d vCenter = new Vector3d(1.0, 1.0, value);
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof View3DWindow)) continue;
            View3DWindow wnd = (View3DWindow)content;
            wnd.objTrans.getTransform(vTrans);
            vTrans.setScale(vCenter);
            wnd.objTrans.setTransform(vTrans);
        }
    }

    public static void setAntialiasing(boolean value) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof View3DWindow)) continue;
            View3DWindow wnd = (View3DWindow)content;
            View view = wnd.u.getViewer().getView();
            view.setSceneAntialiasingEnable(value);
        }
    }

    public void setZValues(Layer layer, Double origDist, Double origThick, Double distance, Double thickness) {
        for (int i = 0; i < this.objTrans.numChildren(); ++i) {
            Shape3D shape;
            J3DAppearance app;
            Node node = this.objTrans.getChild(i);
            if (!(node instanceof Shape3D) || (app = (J3DAppearance)(shape = (Shape3D)node).getAppearance()).getLayer() != layer) continue;
            J3DUtils.updateZValues(shape, origDist.floatValue(), origDist.floatValue() + origThick.floatValue(), distance.floatValue(), distance.floatValue() + thickness.floatValue());
        }
    }

    private J3DAppearance getAppearance(Layer layer) {
        J3DAppearance app = this.layerAppearance.get(layer);
        if (app == null) {
            app = new J3DAppearance(layer, this.lv.isVisible(layer));
            this.layerAppearance.put(layer, app);
        }
        return app;
    }

    private J3DAppearance getAppearance(Color color, float transparency) {
        String key = (color.getRGB() & 0xFFFFFF) + "-" + transparency;
        J3DAppearance app = this.colorAppearance.get(key);
        if (app == null) {
            app = new J3DAppearance(color, transparency);
            app.set3DVisibility(true);
            this.colorAppearance.put(key, app);
        }
        return app;
    }

    @Override
    public void writeImage(ElectricPrinter ep, String filePath) {
        this.canvas.filePath = filePath;
        this.saveImage(false);
    }

    public void saveImage(boolean movieMode) {
        this.canvas.movieMode = movieMode;
        this.canvas.writePNG_ = true;
        this.canvas.repaint();
    }

    @Override
    public boolean initializePrinting(ElectricPrinter ep, PageFormat pageFormat) {
        return false;
    }

    @Override
    public BufferedImage getPrintImage(ElectricPrinter ep) {
        Graphics2D g2d;
        BufferedImage bImage = ep.getBufferedImage();
        if (bImage == null) {
            this.canvas.writePNG_ = true;
            this.canvas.repaint();
            bImage = this.canvas.img;
            ep.setBufferedImage(bImage);
        }
        if ((g2d = (Graphics2D)ep.getGraphics()) != null) {
            AffineTransform t2d = new AffineTransform();
            t2d.translate(ep.getPageFormat().getImageableX(), ep.getPageFormat().getImageableY());
            double xscale = ep.getPageFormat().getImageableWidth() / (double)bImage.getWidth();
            double yscale = ep.getPageFormat().getImageableHeight() / (double)bImage.getHeight();
            double scale = Math.min(xscale, yscale);
            t2d.scale(scale, scale);
            try {
                ElectricPrinter obj = ep;
                g2d.drawImage(bImage, t2d, obj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return bImage;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        Cell cell = (Cell)Cell.findNodeProto(source.getText());
        if (cell == null) {
            return;
        }
        this.setCell(cell, VarContext.globalContext, null);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    public J3DUtils.ThreeDDemoKnot moveAndRotate(double[] values) {
        Vector3f newPos = new Vector3f((float)values[0], (float)values[1], (float)values[2]);
        double factor = 10.0;
        Quat4f quaf = J3DUtils.createQuaternionFromEuler(factor * values[3], factor * values[4], factor * values[5]);
        Transform3D currXform = new Transform3D();
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Variable var = ni.getVar("3D_NODE_DEMO");
            if (var == null) continue;
            List<Node> list = this.electricObjectMap.get(ni);
            for (int i = 0; i < list.size(); ++i) {
                Node obj = list.get(i);
                TransformGroup grp = this.transformGroupMap.get(obj);
                grp.getTransform(currXform);
                currXform.setTranslation(newPos);
                grp.setTransform(currXform);
                grp.getTransform(currXform);
                Matrix4d mat = new Matrix4d();
                currXform.get(mat);
                currXform.setTranslation(new Vector3d(values[6], values[7], values[8]));
                currXform.setRotation(quaf);
                Vector3d translation = new Vector3d(mat.m03, mat.m13, mat.m23);
                currXform.setTranslation(translation);
                grp.setTransform(currXform);
            }
        }
        return new J3DUtils.ThreeDDemoKnot(1.0, newPos, quaf, null);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        Shape3D s;
        this.pickCanvas.setShapeLocation(evt);
        PickResult result = this.pickCanvas.pickClosest();
        this.selectObject(false, true);
        if (result != null && (s = (Shape3D)result.getNode(1)) != null) {
            this.highlighter.addObject(new HighlightShape3D((Node)s), this.cell);
            this.selectObject(true, true);
        }
        WindowFrame.getMouseListener().mouseClicked(evt);
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    public void showCoordinates(MouseEvent evt) {
        View3DWindow wnd = (View3DWindow)evt.getSource();
        if (wnd.getCell() == null) {
            StatusBar.setCoordinates(null, wnd.wf);
        } else {
            Point2D pt = wnd.screenToDatabase(evt.getX(), evt.getY());
            EditingPreferences ep = UserInterfaceMain.getEditingPreferences();
            DBMath.gridAlign(pt, ep.getAlignmentToGrid());
            StatusBar.setCoordinates("(" + TextUtils.formatDouble(pt.getX(), 2) + ", " + TextUtils.formatDouble(pt.getY(), 2) + ")", wnd.wf);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        WindowFrame.getMouseWheelListenerListener().mouseWheelMoved(evt);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        System.out.println("Here keyPressed");
        WindowFrame.getKeyListenerListener().keyPressed(evt);
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        System.out.println("Here keyReleased");
        WindowFrame.getKeyListenerListener().keyReleased(evt);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        System.out.println("Here keyTyped");
        WindowFrame.getKeyListenerListener().keyTyped(evt);
    }

    public Point getLastMousePosition() {
        return new Point(0, 0);
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        Environment newEnv = e.newSnapshot.environment;
        Environment oldEnv = e.oldSnapshot.environment;
        if (newEnv == oldEnv) {
            return;
        }
        if (newEnv.techPool != oldEnv.techPool) {
            Job.getUserInterface().showInformationMessage("3D Window becomes invalid after technology parameters change", "Closing 3D Window");
            this.wf.finished();
            return;
        }
        for (Technology tech : newEnv.techPool.values()) {
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                Setting distanceSetting = layer.getDistanceSetting();
                Setting thicknessSetting = layer.getThicknessSetting();
                Double oldDistance = (Double)oldEnv.getValue(distanceSetting);
                Double oldThickness = (Double)oldEnv.getValue(thicknessSetting);
                Double newDistance = (Double)newEnv.getValue(distanceSetting);
                Double newThickness = (Double)newEnv.getValue(thicknessSetting);
                if (newDistance.equals(oldDistance) && newThickness.equals(oldThickness)) continue;
                this.setZValues(layer, oldDistance, oldThickness, newDistance, newThickness);
            }
        }
    }

    public Point2D screenToDatabase(int screenX, int screenY) {
        double dbX = 0.0;
        double dbY = 0.0;
        return new Point2D.Double(dbX, dbY);
    }

    private void setInterpolator() {
        Transform3D yAxis = new Transform3D();
        ArrayList<J3DUtils.ThreeDDemoKnot> polys = new ArrayList<J3DUtils.ThreeDDemoKnot>();
        double[] zValues = new double[2];
        this.cell.getZValues(zValues);
        double zCenter = (zValues[0] + zValues[1]) / 2.0;
        ERectangle bounding = this.cell.getBounds();
        Vector3d translation = new Vector3d(((RectangularShape)bounding).getCenterX(), ((RectangularShape)bounding).getCenterY(), zCenter);
        yAxis.setTranslation(translation);
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.getProto() != Artwork.tech().pinNode) continue;
            ERectangle rect = ni.getBounds();
            Variable var = ni.getVar("3D_Z_VALUE");
            double zValue = var == null ? zCenter : TextUtils.atof(var.getObject().toString());
            var = ni.getVar("3D_SCALE_VALUE");
            double scale = var == null ? 1.0 : TextUtils.atof(var.getObject().toString());
            var = ni.getVar("3D_HEADING_VALUE");
            double heading = var == null ? 0.0 : TextUtils.atof(var.getObject().toString());
            var = ni.getVar("3D_PITCH_VALUE");
            double pitch = var == null ? 0.0 : TextUtils.atof(var.getObject().toString());
            var = ni.getVar("3D_BANK_VALUE");
            double bank = var == null ? 0.0 : TextUtils.atof(var.getObject().toString());
            var = ni.getVar("3D_ROTX_VALUE");
            double rotX = var == null ? 0.0 : TextUtils.atof(var.getObject().toString());
            var = ni.getVar("3D_ROTY_VALUE");
            double rotY = var == null ? 0.0 : TextUtils.atof(var.getObject().toString());
            var = ni.getVar("3D_ROTZ_VALUE");
            double rotZ = var == null ? 0.0 : TextUtils.atof(var.getObject().toString());
            J3DUtils.ThreeDDemoKnot knot = new J3DUtils.ThreeDDemoKnot(((RectangularShape)rect).getCenterX(), ((RectangularShape)rect).getCenterY(), zValue, scale, heading, pitch, bank, rotX, rotY, rotZ);
            polys.add(knot);
        }
        if (polys.size() == 0) {
            return;
        }
        KBKeyFrame[] splineKeyFrames = new KBKeyFrame[polys.size()];
        TCBKeyFrame[] keyFrames = new TCBKeyFrame[polys.size()];
        for (int i = 0; i < polys.size(); ++i) {
            J3DUtils.ThreeDDemoKnot knot = (J3DUtils.ThreeDDemoKnot)polys.get(i);
            splineKeyFrames[i] = J3DUtils.getNextKBKeyFrame((float)i / (float)(polys.size() - 1), knot);
            keyFrames[i] = J3DUtils.getNextTCBKeyFrame((float)i / (float)(polys.size() - 1), knot);
        }
        RotPosScaleTCBSplinePathInterpolator tcbSplineInter = new RotPosScaleTCBSplinePathInterpolator((Alpha)J3DUtils.jAlpha, this.objTrans, yAxis, keyFrames);
        tcbSplineInter.setSchedulingBounds((Bounds)J3DUtils.infiniteBounds);
        tcbSplineInter.setEnable(false);
        this.interpolatorMap.put(this.objTrans, (Interpolator)tcbSplineInter);
        this.objTrans.addChild((Node)tcbSplineInter);
    }

    public Map<TransformGroup, BranchGroup> addInterpolator(List<J3DUtils.ThreeDDemoKnot> knotList) {
        if (knotList != null && knotList.size() < 2) {
            System.out.println("Needs at least 2 frams for the interpolator");
            return null;
        }
        Map<TransformGroup, BranchGroup> interMap = new HashMap<TransformGroup, BranchGroup>(1);
        Iterator<NodeInst> it = this.cell.getNodes();
        while (it.hasNext()) {
            List<J3DUtils.ThreeDDemoKnot> tmpList;
            NodeInst ni = it.next();
            Variable var = ni.getVar("3D_NODE_DEMO");
            if (var == null || (tmpList = knotList) == null && (tmpList = J3DUtils.readDemoDataFromFile(this)) == null) continue;
            List<Node> list = this.electricObjectMap.get(ni);
            for (int j = 0; j < list.size(); ++j) {
                Node obj = list.get(j);
                TransformGroup grp = this.transformGroupMap.get(obj);
                interMap = this.addInterpolatorPerGroup(tmpList, grp, interMap, false);
            }
        }
        return interMap;
    }

    public Map<TransformGroup, BranchGroup> addInterpolatorPerGroup(List<J3DUtils.ThreeDDemoKnot> knotList, TransformGroup grp, Map<TransformGroup, BranchGroup> interMap, boolean useView) {
        if (knotList == null || knotList.size() < 2) {
            System.out.println("Needs at least 2 frams for the interpolator");
            return null;
        }
        if (interMap == null) {
            interMap = new HashMap<TransformGroup, BranchGroup>(1);
        }
        if (grp == null) {
            grp = !useView ? this.objTrans : this.u.getViewingPlatform().getViewPlatformTransform();
        }
        BranchGroup behaviorBranch = new BranchGroup();
        behaviorBranch.setCapability(17);
        TCBKeyFrame[] keyFrames = new TCBKeyFrame[knotList.size()];
        for (int i = 0; i < knotList.size(); ++i) {
            J3DUtils.ThreeDDemoKnot knot = knotList.get(i);
            keyFrames[i] = J3DUtils.getNextTCBKeyFrame((float)i / (float)(knotList.size() - 1), knot);
        }
        Transform3D yAxis = new Transform3D();
        J3DRotPosScaleTCBSplinePathInterpolator tcbSplineInter = new J3DRotPosScaleTCBSplinePathInterpolator(J3DUtils.jAlpha, grp, yAxis, keyFrames, knotList);
        tcbSplineInter.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), Double.MAX_VALUE));
        behaviorBranch.addChild((Node)tcbSplineInter);
        interMap.put(grp, behaviorBranch);
        grp.addChild((Node)behaviorBranch);
        this.interpolatorMap.put(grp, (Interpolator)tcbSplineInter);
        return interMap;
    }

    public void removeInterpolator(Map<TransformGroup, BranchGroup> interMap) {
        this.canvas.resetMoveFrames();
        for (TransformGroup grp : interMap.keySet()) {
            Node node = (Node)interMap.get(grp);
            grp.removeChild(node);
        }
    }

    protected double getScale() {
        return 0.05;
    }

    Vector3d getMapSize() {
        if (mapSize == null) {
            mapSize = new Vector3d(2.0, 0.0, 2.0);
        }
        return mapSize;
    }

    Point2d convertToMapCoordinate(Vector3d worldCoord) {
        Point2d point2d = new Point2d();
        Vector3d squareSize = this.getMapSize();
        point2d.x = (worldCoord.x + (double)this.getPanel().getWidth()) / squareSize.x;
        point2d.y = (worldCoord.z + (double)this.getPanel().getHeight()) / squareSize.z;
        return point2d;
    }

    public boolean isCollision(Transform3D t3d) {
        t3d.get(tmpVec);
        tmpVec.scale(1.0 / this.getScale());
        return this.isCollision(tmpVec);
    }

    protected boolean isCollision(Vector3d worldCoord) {
        Point2d point = this.convertToMapCoordinate(worldCoord);
        this.pickCanvas.setShapeLocation((int)point.x, (int)point.y);
        PickResult result = this.pickCanvas.pickClosest();
        if (result != null && result.getNode(1) != null) {
            for (int i = 0; i < result.numIntersections(); ++i) {
                PickIntersection inter = result.getIntersection(i);
                if (!(inter.getDistance() < 6.0)) continue;
                return true;
            }
        }
        return false;
    }

    public J3DUtils.ThreeDDemoKnot addFrame(boolean useView) {
        Transform3D tmpTrans = new Transform3D();
        if (!useView) {
            this.objTrans.getTransform(tmpTrans);
        } else {
            this.u.getViewingPlatform().getViewPlatformTransform().getTransform(tmpTrans);
        }
        tmpTrans.get(tmpVec);
        Quat4f rot = new Quat4f();
        tmpTrans.get(rot);
        Shape3D shape = null;
        return new J3DUtils.ThreeDDemoKnot(1.0, new Vector3f(tmpVec), rot, shape);
    }

    public void saveMovie(File file) {
        if (file != null) {
            this.canvas.saveMovie(file);
        }
    }

    private static class View3DWindowJob
    extends Job {
        private Cell cell;
        private transient WindowFrame windowFrame;
        private transient WindowContent view2D;
        private boolean transPerNode;
        private List<PolyBase> overridePolygons;

        public View3DWindowJob(Cell cell, List<PolyBase> overridePolygons, WindowFrame wf, WindowContent view2D, boolean transPerNode) {
            super("3D View Job", null, Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.overridePolygons = overridePolygons;
            this.windowFrame = wf;
            this.view2D = view2D;
            this.transPerNode = transPerNode;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            return true;
        }

        @Override
        public void terminateOK() {
            View3DWindow window = new View3DWindow(this.cell, this.overridePolygons, this.windowFrame, this.view2D, this.transPerNode, this);
            this.windowFrame.finishWindowFrameInformation(window, this.cell);
            if (!TopLevel.isMDIMode()) {
                for (Component comp : this.windowFrame.getFrame().getToolBar().getComponents()) {
                    comp.setVisible(false);
                }
            }
        }
    }

    private class View3DEnumerator
    extends HierarchyEnumerator.Visitor {
        public View3DEnumerator(Cell cell) {
            Technology tech = cell.getTechnology();
            Layer poly = tech.findLayerFromFunction(Layer.Function.POLY1, -1);
            Layer gate = tech.findLayerFromFunction(Layer.Function.GATE, -1);
            if (poly != null && gate != null && !DBMath.areEquals(poly.getDistance(), gate.getDistance())) {
                View3DWindow.this.locosShape = true;
            }
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (View3DWindow.this.job != null && View3DWindow.this.job.checkAbort()) {
                return false;
            }
            if (!View3DWindow.this.isSizeLimitOK(info.getCell().getNumArcs() + View3DWindow.this.objTrans.numChildren())) {
                return false;
            }
            FixpTransform rTrans = info.getTransformToRoot();
            Iterator<ArcInst> it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (ai.getBounds().isEmpty()) {
                    System.out.println("Skipping arc '" + ai.getName() + "' due to its zero area");
                    continue;
                }
                View3DWindow.this.addArc(ai, rTrans, View3DWindow.this.objTrans);
            }
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            if (View3DWindow.this.reachLimit) {
                return false;
            }
            if (View3DWindow.this.job != null && View3DWindow.this.job.checkAbort()) {
                return false;
            }
            NodeInst ni = no.getNodeInst();
            if (ni.getBounds().isEmpty()) {
                System.out.println("Skipping node '" + ni.getName() + "' due to its zero area");
                return false;
            }
            FixpTransform trans = ni.rotateOutAboutTrueCenter();
            FixpTransform root = info.getTransformToRoot();
            if (root.getType() != 0) {
                trans.preConcatenate(root);
            }
            TransformGroup grp = View3DWindow.this.objTrans;
            if (View3DWindow.this.oneTransformPerNode) {
                grp = new TransformGroup();
                grp.setCapability(18);
                grp.setCapability(17);
                grp.setCapability(14);
                grp.setCapability(12);
                grp.setCapability(13);
                View3DWindow.this.objTrans.addChild((Node)grp);
            }
            View3DWindow.this.addNode(ni, trans, grp);
            if (!View3DWindow.this.isSizeLimitOK(grp.numChildren())) {
                return false;
            }
            return ni.isExpanded();
        }
    }

    private static class HighlightShape3D {
        Node shape;
        Appearance origApp;

        HighlightShape3D(Node n) {
            this.shape = n;
            this.origApp = HighlightShape3D.getAppearance(n);
        }

        static Appearance getAppearance(Node n) {
            if (n instanceof Shape3D) {
                return ((Shape3D)n).getAppearance();
            }
            if (n instanceof Primitive) {
                return ((Primitive)n).getAppearance();
            }
            assert (false);
            return null;
        }

        void setAppearance(Appearance a) {
            if (this.shape instanceof Shape3D) {
                ((Shape3D)this.shape).setAppearance(a);
            } else if (this.shape instanceof Primitive) {
                ((Primitive)this.shape).setAppearance(a);
            } else assert (false);
        }
    }

    private static class J3DRotPosScaleTCBSplinePathInterpolator
    extends RotPosScaleTCBSplinePathInterpolator {
        public J3DRotPosScaleTCBSplinePathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, TCBKeyFrame[] keys, List<J3DUtils.ThreeDDemoKnot> list) {
            super(alpha, target, axisOfTransform, keys);
        }

        public void processStimulus(Iterator<WakeupCriterion> arg0) {
            super.processStimulus(arg0);
        }
    }
}

