/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.result.EquivRecReport;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.NetObjReport;
import com.sun.electric.tool.ncc.result.PartReport;
import com.sun.electric.tool.ncc.result.WireReport;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ncc.ComparisonsTree;
import com.sun.electric.tool.user.ncc.EquivClassSplitPane;
import com.sun.electric.tool.user.ncc.ExportAssertionTable;
import com.sun.electric.tool.user.ncc.ExportConflictTable;
import com.sun.electric.tool.user.ncc.ExportMismatchTable;
import com.sun.electric.tool.user.ncc.HighlightTools;
import com.sun.electric.tool.user.ncc.NccGuiInfo;
import com.sun.electric.tool.user.ncc.SizeMismatchPane;
import com.sun.electric.tool.user.ncc.UnrecognizedPartTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComparisonsPane
extends JSplitPane
implements ActionListener {
    private static final int EMPTY = 0;
    private static final int COMP_SUMMARY = 1;
    private static final int EXPORTS = 2;
    private static final int PARTS_WIRES = 3;
    private static final int SIZES = 4;
    private static final int EXPORT_ASSERTS = 5;
    private static final int EXPORT_NET_CONF = 6;
    private static final int EXPORT_CHR_CONF = 7;
    private static final int UNRECOG_PART = 8;
    private static final int MAX_CONCUR_EQ_RECS = 5;
    private static final String emptyStr = " ";
    private static final String LSEP = System.getProperty("line.separator");
    protected String[] defaultTitles = new String[]{" ", " "};
    private String treeTitle = "  Mismatched Comparisons";
    private JLabel treeLabel = new JLabel(this.treeTitle);
    private ComparisonsTree tree;
    private JScrollPane treeScrollPane;
    private int dispOnRight = 0;
    private static Border border = BorderFactory.createEmptyBorder();
    private JScrollPane[] exportsPanes;
    private JScrollPane[] exportAssertionsPanes;
    private JScrollPane[] exportNetConflictPanes;
    private JScrollPane[] exportChrConflictPanes;
    private JScrollPane[] unrecognizedPartsPanes;
    private EquivClassSplitPane[] rightSplPanes;
    private JPanel[] sizesPanes;
    protected JPopupMenu treePopup;
    protected JPopupMenu cellPopup;
    protected String clipboard;
    private NccGuiInfo[] mismatches;
    private EquivRecReport[][] mismEqRecs;
    private List<NetObjReport>[][][] mismNetObjs;
    private List<NetObjReport>[][][] matchedNetObjs;
    private Vector<ComparisonsTree.TreeNode> curEqRecNodes = new Vector();
    private Vector<ComparisonsTree.TreeNode> curEqRecNodesToDisplay = new Vector();
    private Vector<ComparisonsTree.TreeNode> curExlusiveNodes = new Vector();

    public ComparisonsPane() {
        super(1);
        this.setOneTouchExpandable(true);
        this.setDividerLocation(0.5);
        this.setResizeWeight(0.2);
        this.createCellPopup();
        this.rightSplPanes = new EquivClassSplitPane[5];
        for (int i = 0; i < 5; ++i) {
            this.rightSplPanes[i] = new EquivClassSplitPane(this, i + 1);
        }
        this.setRightComponent(this.rightSplPanes[0]);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.treeLabel, "North");
        leftPanel.setBorder(border);
        ComparisonsTree.TreeNode rootNode = new ComparisonsTree.TreeNode(null, this.treeTitle, -1, -1, 0);
        this.tree = new ComparisonsTree(this, new DefaultMutableTreeNode(rootNode));
        this.treeScrollPane = new JScrollPane(this.tree);
        leftPanel.add((Component)this.treeScrollPane, "Center");
        this.setLeftComponent(leftPanel);
    }

    public void setMismatches(List<NccGuiInfo> misms) {
        this.mismatches = misms.toArray(new NccGuiInfo[0]);
        this.mismEqRecs = new EquivRecReport[this.mismatches.length][];
        this.mismNetObjs = new ArrayList[this.mismatches.length][][];
        this.matchedNetObjs = new ArrayList[this.mismatches.length][][];
        this.exportsPanes = new JScrollPane[this.mismatches.length];
        this.exportAssertionsPanes = new JScrollPane[this.mismatches.length];
        this.exportNetConflictPanes = new JScrollPane[this.mismatches.length];
        this.exportChrConflictPanes = new JScrollPane[this.mismatches.length];
        this.unrecognizedPartsPanes = new JScrollPane[this.mismatches.length];
        this.sizesPanes = new JPanel[this.mismatches.length];
        this.curEqRecNodes.clear();
        this.curEqRecNodesToDisplay.clear();
        this.curExlusiveNodes.clear();
        int divPos = this.getDividerLocation();
        this.dispOnRight = 1;
        this.displayComparisonSummary(0);
        this.setDividerLocation(divPos);
        StringBuffer buf = new StringBuffer(this.treeTitle + " [");
        if (this.mismatches.length > 100) {
            buf.append("first 100 of ");
        }
        buf.append(this.mismatches.length + "]");
        this.treeLabel.setText(buf.toString());
        this.tree.update(this.mismatches);
        this.treeScrollPane.getVerticalScrollBar().setValue(0);
        this.getExportsPane(0);
    }

    protected void setMismatchEquivRecs(int compNdx, EquivRecReport[] equivRecs) {
        this.mismEqRecs[compNdx] = equivRecs;
        this.mismNetObjs[compNdx] = new ArrayList[equivRecs.length][];
        this.matchedNetObjs[compNdx] = new ArrayList[equivRecs.length][];
    }

    protected EquivRecReport[] getMismatchEquivRecs(int compNdx) {
        return this.mismEqRecs[compNdx];
    }

    private void resetRightPane() {
        int divPos = this.getDividerLocation();
        for (int j = 0; j < 2; ++j) {
            this.rightSplPanes[0].setLabelText(0, j, this.defaultTitles[j]);
            this.rightSplPanes[0].setCellText(0, j, emptyStr);
        }
        this.setRightComponent(this.rightSplPanes[0]);
        this.setDividerLocation(divPos);
        this.dispOnRight = 0;
    }

    private JScrollPane getExportsPane(int compNdx) {
        if (compNdx < 0 || compNdx >= this.exportsPanes.length) {
            return null;
        }
        if (this.exportsPanes[compNdx] == null) {
            ExportMismatchTable table = new ExportMismatchTable(this.mismatches[compNdx]);
            this.exportsPanes[compNdx] = new JScrollPane(table);
            this.exportsPanes[compNdx].setBackground(Color.WHITE);
        }
        return this.exportsPanes[compNdx];
    }

    private JScrollPane getExportAssertionPane(int compNdx) {
        if (compNdx < 0 || compNdx >= this.exportAssertionsPanes.length) {
            return null;
        }
        if (this.exportAssertionsPanes[compNdx] == null) {
            ExportAssertionTable table = new ExportAssertionTable(this.mismatches[compNdx]);
            this.exportAssertionsPanes[compNdx] = new JScrollPane(table);
            this.exportAssertionsPanes[compNdx].setBackground(Color.WHITE);
        }
        return this.exportAssertionsPanes[compNdx];
    }

    private JScrollPane getExportNetConflictPane(int compNdx) {
        if (compNdx < 0 || compNdx >= this.exportNetConflictPanes.length) {
            return null;
        }
        if (this.exportNetConflictPanes[compNdx] == null) {
            ExportConflictTable.NetworkTable table = new ExportConflictTable.NetworkTable(this.mismatches[compNdx]);
            this.exportNetConflictPanes[compNdx] = new JScrollPane(table);
            this.exportNetConflictPanes[compNdx].setBackground(Color.WHITE);
        }
        return this.exportNetConflictPanes[compNdx];
    }

    private JScrollPane getExportChrConflictPane(int compNdx) {
        if (compNdx < 0 || compNdx >= this.exportChrConflictPanes.length) {
            return null;
        }
        if (this.exportChrConflictPanes[compNdx] == null) {
            ExportConflictTable.CharacteristicsTable table = new ExportConflictTable.CharacteristicsTable(this.mismatches[compNdx]);
            this.exportChrConflictPanes[compNdx] = new JScrollPane(table);
            this.exportChrConflictPanes[compNdx].setBackground(Color.WHITE);
        }
        return this.exportChrConflictPanes[compNdx];
    }

    private JScrollPane getUnrecognizedPartsPane(int compNdx) {
        if (compNdx < 0 || compNdx >= this.unrecognizedPartsPanes.length) {
            return null;
        }
        if (this.unrecognizedPartsPanes[compNdx] == null) {
            UnrecognizedPartTable table = new UnrecognizedPartTable(this.mismatches[compNdx]);
            this.unrecognizedPartsPanes[compNdx] = new JScrollPane(table);
            this.unrecognizedPartsPanes[compNdx].setBackground(Color.WHITE);
        }
        return this.unrecognizedPartsPanes[compNdx];
    }

    private JPanel getSizesPane(int compNdx) {
        if (compNdx < 0 || compNdx >= this.sizesPanes.length) {
            return null;
        }
        if (this.sizesPanes[compNdx] == null) {
            this.sizesPanes[compNdx] = new SizeMismatchPane(this.mismatches[compNdx]);
        }
        return this.sizesPanes[compNdx];
    }

    public void treeSelectionChanged(ComparisonsTree.TreeNode node, boolean added) {
        if (node == null) {
            return;
        }
        int type = node.type;
        if (type == 0) {
            return;
        }
        if (type == 5 || type == 6) {
            node = node.getParent();
            type = node.type;
        }
        if (!added) {
            if (type == 3 || type == 4) {
                this.curEqRecNodes.remove(node);
            } else {
                this.curExlusiveNodes.remove(node);
            }
        } else if (type == 3 || type == 4) {
            this.curEqRecNodes.add(node);
        } else {
            this.curExlusiveNodes.add(node);
        }
    }

    public void updateRightPane() {
        int divPos = this.getDividerLocation();
        if (this.curExlusiveNodes.size() > 0) {
            ComparisonsTree.TreeNode exNode = this.curExlusiveNodes.firstElement();
            int exType = exNode.type;
            switch (exType) {
                case 1: {
                    this.dispOnRight = 1;
                    this.displayComparisonSummary(exNode.compNdx);
                    break;
                }
                case 2: {
                    this.dispOnRight = 2;
                    this.setRightComponent(this.getExportsPane(exNode.compNdx));
                    break;
                }
                case 7: {
                    this.dispOnRight = 4;
                    this.setRightComponent(this.getSizesPane(exNode.compNdx));
                    break;
                }
                case 8: {
                    this.dispOnRight = 5;
                    this.setRightComponent(this.getExportAssertionPane(exNode.compNdx));
                    break;
                }
                case 9: {
                    this.dispOnRight = 6;
                    this.setRightComponent(this.getExportNetConflictPane(exNode.compNdx));
                    break;
                }
                case 10: {
                    this.dispOnRight = 7;
                    this.setRightComponent(this.getExportChrConflictPane(exNode.compNdx));
                    break;
                }
                case 11: {
                    this.dispOnRight = 8;
                    this.setRightComponent(this.getUnrecognizedPartsPane(exNode.compNdx));
                }
            }
            this.setDividerLocation(divPos);
            return;
        }
        if (this.curEqRecNodes.size() == 0) {
            this.resetRightPane();
            return;
        }
        this.dispOnRight = 3;
        this.curEqRecNodesToDisplay.clear();
        int i = 0;
        Iterator<ComparisonsTree.TreeNode> it = this.curEqRecNodes.iterator();
        while (it.hasNext() && i < 5) {
            ComparisonsTree.TreeNode eqRecNode = it.next();
            if (this.curEqRecNodesToDisplay.contains(eqRecNode)) continue;
            this.curEqRecNodesToDisplay.add(eqRecNode);
            ++i;
        }
        EquivClassSplitPane rightSplPane = this.rightSplPanes[this.curEqRecNodesToDisplay.size() - 1];
        i = 0;
        for (ComparisonsTree.TreeNode eqRecNode : this.curEqRecNodesToDisplay) {
            String partitionTitle = eqRecNode.getParent().getShortName() + " : " + eqRecNode.getShortName();
            rightSplPane.setPartitionTitle(i, partitionTitle);
            ArrayList[] mism = new ArrayList[2];
            EquivRecReport eqRec = this.mismEqRecs[eqRecNode.compNdx][eqRecNode.eclass];
            mism[0] = eqRec.getNotMatchedNetObjs().get(0);
            mism[1] = eqRec.getNotMatchedNetObjs().get(1);
            this.mismNetObjs[eqRecNode.compNdx][eqRecNode.eclass] = mism;
            ArrayList[] matched = new ArrayList[]{eqRec.getMatchedNetObjs().get(0), eqRec.getMatchedNetObjs().get(1)};
            this.matchedNetObjs[eqRecNode.compNdx][eqRecNode.eclass] = matched;
            this.fillLocalPartitionResults(eqRecNode, rightSplPane, i);
            ++i;
        }
        this.setRightComponent(rightSplPane);
        this.setDividerLocation(divPos);
        rightSplPane.updateLayout();
    }

    private void fillLocalPartitionResults(ComparisonsTree.TreeNode node, EquivClassSplitPane pane, int row) {
        int swap = 0;
        if (this.mismatches[node.compNdx].isSwapCells()) {
            swap = 1;
        }
        List<NetObjReport>[] matched = this.matchedNetObjs[node.compNdx][node.eclass];
        List<NetObjReport>[] mism = this.mismNetObjs[node.compNdx][node.eclass];
        String href = "<a style=\"text-decoration: none\" href=\"";
        StringBuffer html = new StringBuffer(256);
        for (int cell = 0; cell < 2; ++cell) {
            int len;
            int ndx = (cell + swap) % 2;
            StringBuffer curCellText = pane.getCellPlainTextBuffer(row, ndx);
            curCellText.setLength(0);
            html.setLength(0);
            html.append("<html><FONT SIZE=3><FONT FACE=\"Helvetica, TimesRoman\">");
            if (mism[ndx].size() > 0) {
                html.append("<font COLOR=\"red\">");
                for (int k = 0; k < mism[ndx].size() && k < 200; ++k) {
                    String descr = this.cleanNetObjectName(mism[ndx].get(k).instanceDescription());
                    html.append(href + (row * 100000 + ndx * 10000 + k) + "\">" + descr + "</a>");
                    curCellText.append(descr);
                    html.append("<br>");
                    curCellText.append(LSEP);
                }
                html.append("</font>");
            }
            int sizeDiff = mism[(ndx + 1) % 2].size() - mism[ndx].size();
            if (matched[ndx].size() > 0) {
                while (sizeDiff-- > 0) {
                    html.append("<br>");
                    curCellText.append(LSEP);
                }
            }
            if (matched[ndx].size() > 0) {
                html.append("<font COLOR=\"green\">");
                for (int k = 0; k < matched[ndx].size() && k < 200; ++k) {
                    String descr = this.cleanNetObjectName(matched[ndx].get(k).instanceDescription());
                    html.append(href + (row * 100000 + ndx * 10000 + (mism[ndx].size() + k)) + "\">" + descr + "</a>");
                    curCellText.append(descr);
                    html.append("<br>");
                    curCellText.append(LSEP);
                }
                html.append("</font>");
            }
            if ((len = mism[ndx].size() + matched[ndx].size()) == 0) {
                html.append("<b>none</b>");
                curCellText.append("none");
            }
            html.append("</font></html>");
            pane.setCellText(row, ndx, html.toString());
            String title = this.mismatches[node.compNdx].getNames()[ndx];
            if (node.type == 4) {
                pane.setLabelText(row, ndx, "  " + len + " Wire(s) in " + title);
                continue;
            }
            pane.setLabelText(row, ndx, "  " + len + " Part(s) in " + title);
        }
    }

    private void displayComparisonSummary(int compNdx) {
        EquivClassSplitPane rightSplPane = this.rightSplPanes[0];
        Cell[] cells = this.mismatches[compNdx].getCells();
        NccResult.CellSummary summary = this.mismatches[compNdx].getCellSummary();
        StringBuffer html = new StringBuffer(256);
        int swap = 0;
        if (this.mismatches[compNdx].isSwapCells()) {
            swap = 1;
        }
        for (int i = 0; i < 2; ++i) {
            int ndx = (i + swap) % 2;
            StringBuffer curCellText = rightSplPane.getCellPlainTextBuffer(0, ndx);
            curCellText.setLength(0);
            html.setLength(0);
            html.append("<html><FONT SIZE=3><FONT FACE=\"Helvetica, TimesRoman\">");
            if (summary.cantBuildNetlist[ndx]) {
                html.append("  See problems listed<br>in tree pane.<br>(left most pane). ");
                curCellText.append("  See problems listed" + LSEP + "in tree pane." + LSEP + "(left most pane). ");
            } else {
                html.append(summary.numParts[ndx] + " Parts<br>" + summary.numWires[ndx] + " Wires<br>" + summary.numPorts[ndx] + " Ports<br>");
                curCellText.append(summary.numParts[ndx] + " Parts" + LSEP + summary.numWires[ndx] + " Wires" + LSEP + summary.numPorts[ndx] + " Ports");
            }
            html.append("</font></html>");
            rightSplPane.setCellText(0, ndx, html.toString());
            CellName cellName = cells[i].getCellName();
            String name = "  Summary of " + cellName.getName() + emptyStr + cellName.getView().getAbbreviationExtension();
            rightSplPane.setLabelText(0, ndx, name);
        }
        this.setRightComponent(rightSplPane);
    }

    void highlight(int index) {
        int recNdx = index / 100000;
        int cellNdx = index / 10000 % 10;
        int line = index % 10000;
        ComparisonsTree.TreeNode eqRecNode = this.curEqRecNodesToDisplay.elementAt(recNdx);
        NetObjReport partOrWire = null;
        List<NetObjReport>[] mism = this.mismNetObjs[eqRecNode.compNdx][eqRecNode.eclass];
        List<NetObjReport>[] matched = this.matchedNetObjs[eqRecNode.compNdx][eqRecNode.eclass];
        partOrWire = line >= mism[cellNdx].size() ? matched[cellNdx].get(line - mism[cellNdx].size()) : mism[cellNdx].get(line);
        Cell cell = null;
        VarContext context = null;
        if (partOrWire instanceof PartReport) {
            cell = ((PartReport)partOrWire).getNameProxy().leafCell();
            context = ((PartReport)partOrWire).getNameProxy().getContext();
        } else if (partOrWire instanceof WireReport) {
            cell = ((WireReport)partOrWire).getNameProxy().leafCell();
            context = ((WireReport)partOrWire).getNameProxy().getContext();
        }
        Highlighter highlighter = HighlightTools.getHighlighter(cell, context);
        if (highlighter == null) {
            return;
        }
        if (partOrWire instanceof PartReport) {
            HighlightTools.highlightPart(highlighter, cell, (PartReport)partOrWire);
        } else if (partOrWire instanceof WireReport) {
            HighlightTools.highlightWire(highlighter, cell, (WireReport)partOrWire);
        }
        highlighter.finished();
    }

    public String cleanNetObjectName(String descr) {
        int ind;
        if (descr.startsWith("Wire: ") || descr.startsWith("Part: ")) {
            descr = descr.substring(6);
        }
        if ((ind = descr.indexOf(" Cell instance:")) > 0) {
            descr = descr.substring(0, ind).trim();
        }
        if (descr.endsWith("{sch}") || descr.endsWith("{lay}")) {
            descr = descr.substring(0, descr.length() - 5);
        }
        return descr;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(this.clipboard);
        cb.setContents(ss, ss);
    }

    private void createCellPopup() {
        this.cellPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy Cell Text To Clipboard");
        menuItem.addActionListener(this);
        this.cellPopup.add(menuItem);
    }

    void showCellPopup(String text, Component c, int x, int y) {
        this.clipboard = text;
        this.cellPopup.show(c, x, y);
    }
}

