/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.strategy.StratHashParts;
import com.sun.electric.tool.ncc.strategy.StratHashWires;
import com.sun.electric.tool.ncc.strategy.StratPortName;
import com.sun.electric.tool.ncc.strategy.StratRandomMatch;
import com.sun.electric.tool.ncc.strategy.StratSizes;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HashCodePartitioningNew {
    NccGlobals globals;

    private void hashFrontierParts(HashCodePropagator hashProp) {
        if (this.globals.getParts() == null) {
            return;
        }
        this.globals.status2("----- hash all Parts on frontier");
        Iterator<EquivRecord> eIt = this.globals.getPartLeafEquivRecs().getNotMatched();
        while (eIt.hasNext()) {
            EquivRecord er = eIt.next();
            if (!er.isLeaf() || er.isMismatched()) continue;
            LeafList newBornList = StratHashParts.doYourJob(er, this.globals);
            hashProp.propagateFromNewBorns(newBornList);
        }
    }

    private void hashFrontierWires(HashCodePropagator hashProp) {
        if (this.globals.getWires() == null) {
            return;
        }
        this.globals.status2("----- hash all Wires on frontier");
        Iterator<EquivRecord> eIt = this.globals.getWireLeafEquivRecs().getNotMatched();
        while (eIt.hasNext()) {
            EquivRecord er = eIt.next();
            if (!er.isLeaf() || er.isMismatched()) continue;
            LeafList newBornList = StratHashWires.doYourJob(er, this.globals);
            hashProp.propagateFromNewBorns(newBornList);
        }
    }

    private void hashFrontier(HashCodePropagator hashProp) {
        this.globals.status2("----- hash all NetObjects on frontier");
        this.hashFrontierParts(hashProp);
        this.hashFrontierWires(hashProp);
    }

    private boolean done() {
        return this.globals.getWireLeafEquivRecs().numNotMatched() == 0 && this.globals.getPartLeafEquivRecs().numNotMatched() == 0;
    }

    private void useExportNames(HashCodePropagator hashProp) {
        LeafList offspring;
        this.globals.status2("----- use Export Names");
        while ((offspring = StratPortName.doYourJob(this.globals)).size() != 0) {
            hashProp.propagateFromNewBorns(offspring);
        }
    }

    private void useTransistorSizes(HashCodePropagator hashProp) {
        LeafList offspring;
        this.globals.status2("----- use transistor sizes");
        while ((offspring = StratSizes.doYourJob(this.globals)).size() != 0) {
            hashProp.propagateFromNewBorns(offspring);
        }
    }

    private void randomMatch(HashCodePropagator hashProp) {
        LeafList offspring;
        this.globals.status2("----- random matching");
        while ((offspring = StratRandomMatch.doYourJob(this.globals)).size() != 0) {
            hashProp.propagateFromNewBorns(offspring);
        }
    }

    private void doWork() {
        if (this.done()) {
            return;
        }
        Date d1 = new Date();
        HashCodePropagator hashProp = new HashCodePropagator(this.globals);
        this.hashFrontier(hashProp);
        Date d2 = new Date();
        this.globals.status1("  Hashing frontier took: " + NccUtils.hourMinSec(d1, d2));
        if (this.done() || this.globals.userWantsToAbort()) {
            return;
        }
        this.useExportNames(hashProp);
        Date d3 = new Date();
        this.globals.status1("  Using export names took: " + NccUtils.hourMinSec(d2, d3));
        if (this.done() || this.globals.userWantsToAbort()) {
            return;
        }
        this.useTransistorSizes(hashProp);
        Date d4 = new Date();
        this.globals.status1("  Using transistor sizes took: " + NccUtils.hourMinSec(d3, d4));
        if (this.done() || this.globals.userWantsToAbort()) {
            return;
        }
        this.randomMatch(hashProp);
        Date d5 = new Date();
        this.globals.status1("  Random match took: " + NccUtils.hourMinSec(d4, d5));
    }

    private boolean allPartsWiresMatch() {
        return this.globals.getPartLeafEquivRecs().numNotMatched() == 0 && this.globals.getWireLeafEquivRecs().numNotMatched() == 0;
    }

    private HashCodePartitioningNew(NccGlobals globals) {
        this.globals = globals;
        globals.status2("----- starting HashCodePartitioningNew");
        this.doWork();
        globals.status2("----- done HashCodePartitioningNew");
    }

    public static boolean doYourJob(NccGlobals globals) {
        HashCodePartitioningNew p = new HashCodePartitioningNew(globals);
        return p.allPartsWiresMatch();
    }

    private static class HashCodePropagator {
        NccGlobals globals;
        private final int MAX_REC_BIRTHDAYS = 1000;
        private int todaysDate = 1;
        private Map<EquivRecord, Integer> recToRehashDate = new HashMap<EquivRecord, Integer>();
        private LinkedList<ChildAndBirthday> matchedNewBorns = new LinkedList();
        private LinkedList<ChildAndBirthday> activeNewBorns = new LinkedList();
        private LinkedList<ChildAndBirthday> mismatchedNewBorns = new LinkedList();

        private ChildAndBirthday selectHighPriorityNewBorn2() {
            if (!this.matchedNewBorns.isEmpty()) {
                return this.matchedNewBorns.removeFirst();
            }
            if (!this.activeNewBorns.isEmpty()) {
                return this.activeNewBorns.removeFirst();
            }
            if (!this.mismatchedNewBorns.isEmpty()) {
                return this.mismatchedNewBorns.removeFirst();
            }
            return null;
        }

        private ChildAndBirthday selectHighPriorityNewBorn() {
            ChildAndBirthday cf;
            do {
                if ((cf = this.selectHighPriorityNewBorn2()) != null) continue;
                return null;
            } while (!cf.child.isLeaf());
            return cf;
        }

        private void addAll(LeafList newBorns) {
            ++this.todaysDate;
            if (this.recToRehashDate.size() > 1000) {
                System.out.println("  NCC: Reached MAX_REC_BIRTHDAYS: 1000");
                this.recToRehashDate.clear();
            }
            Iterator<EquivRecord> erIt = newBorns.iterator();
            while (erIt.hasNext()) {
                EquivRecord er = erIt.next();
                LayoutLib.error(er == null, "null not allowed");
                if (er.isMatched()) {
                    this.matchedNewBorns.add(new ChildAndBirthday(er, this.todaysDate));
                    continue;
                }
                if (er.isMismatched()) {
                    this.mismatchedNewBorns.add(new ChildAndBirthday(er, this.todaysDate));
                    continue;
                }
                this.activeNewBorns.add(new ChildAndBirthday(er, this.todaysDate));
            }
            ++this.todaysDate;
        }

        private List<EquivRecord> findStaleAdjacentTo(ChildAndBirthday cb) {
            int childsBirthday = cb.birthday;
            EquivRecord child = cb.child;
            ArrayList<EquivRecord> adjacent = new ArrayList<EquivRecord>();
            Iterator<Circuit> ci = child.getCircuits();
            while (ci.hasNext()) {
                Circuit jc = ci.next();
                Iterator<NetObject> ni = jc.getNetObjs();
                while (ni.hasNext()) {
                    NetObject netObj = ni.next();
                    Iterator<NetObject> it = netObj.getConnected();
                    while (it.hasNext()) {
                        EquivRecord neighbor = it.next().getParent().getParent();
                        if (neighbor.isActive()) {
                            Integer rehashDate = this.recToRehashDate.get(neighbor);
                            if (rehashDate != null && rehashDate >= childsBirthday) continue;
                            adjacent.add(neighbor);
                            this.recToRehashDate.put(neighbor, this.todaysDate);
                            continue;
                        }
                        this.recToRehashDate.remove(neighbor);
                    }
                }
            }
            return adjacent;
        }

        private List<EquivRecord> findStaleAdjacentToHighestPriorityNewBorn() {
            ChildAndBirthday cb;
            List<EquivRecord> adjacent;
            do {
                if ((cb = this.selectHighPriorityNewBorn()) != null) continue;
                return new ArrayList<EquivRecord>();
            } while ((adjacent = this.findStaleAdjacentTo(cb)).isEmpty());
            return adjacent;
        }

        public HashCodePropagator(NccGlobals glob) {
            this.globals = glob;
        }

        public void propagateFromNewBorns(LeafList newBornList) {
            List<EquivRecord> adjacent;
            this.addAll(newBornList);
            while (!(adjacent = this.findStaleAdjacentToHighestPriorityNewBorn()).isEmpty()) {
                for (EquivRecord er : adjacent) {
                    if (!er.isLeaf()) continue;
                    if (er.getNetObjType() == NetObject.Type.PART) {
                        this.addAll(StratHashParts.doYourJob(er, this.globals));
                        continue;
                    }
                    this.addAll(StratHashWires.doYourJob(er, this.globals));
                }
            }
        }

        public static class ChildAndBirthday {
            EquivRecord child;
            int birthday;

            ChildAndBirthday(EquivRecord child, int birthday) {
                this.child = child;
                this.birthday = birthday;
            }
        }
    }
}

