/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.CellUsage;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.LibId;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.UsageCollector;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Generic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellBackup {
    public static final CellBackup[] NULL_ARRAY = new CellBackup[0];
    public static final ImmutableArrayList<CellBackup> EMPTY_LIST = new ImmutableArrayList<CellBackup>(NULL_ARRAY);
    private static final int[] NULL_INT_ARRAY = new int[0];
    static final CellUsageInfo[] NULL_CELL_USAGE_INFO_ARRAY = new CellUsageInfo[0];
    public final ImmutableCell d;
    public final long revisionDate;
    public final boolean modified;
    public final ImmutableArrayList<ImmutableExport> exports;
    public final ImmutableArrayList<ImmutableNodeInst> nodes;
    public final ImmutableArrayList<ImmutableArcInst> arcs;
    final BitSet usedLibs;
    final CellUsageInfo[] cellUsages;
    final int[] exportIndex;
    final BitSet definedExports;
    final int definedExportsLength;
    final BitSet deletedExports;

    private CellBackup(ImmutableCell d, long revisionDate, boolean modified, ImmutableArrayList<ImmutableNodeInst> nodes, ImmutableArrayList<ImmutableArcInst> arcs, ImmutableArrayList<ImmutableExport> exports, BitSet usedLibs, CellUsageInfo[] cellUsages, int[] exportIndex, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        this.d = d;
        this.revisionDate = revisionDate;
        this.modified = modified;
        this.nodes = nodes;
        this.arcs = arcs;
        this.exports = exports;
        this.usedLibs = usedLibs;
        this.cellUsages = cellUsages;
        this.exportIndex = exportIndex;
        this.definedExports = definedExports;
        this.definedExportsLength = definedExportsLength;
        this.deletedExports = deletedExports;
    }

    public CellBackup(ImmutableCell d) {
        this(d, 0L, false, ImmutableNodeInst.EMPTY_LIST, ImmutableArcInst.EMPTY_LIST, ImmutableExport.EMPTY_LIST, UsageCollector.EMPTY_BITSET, NULL_CELL_USAGE_INFO_ARRAY, NULL_INT_ARRAY, UsageCollector.EMPTY_BITSET, 0, UsageCollector.EMPTY_BITSET);
        if (d.cellName == null) {
            throw new NullPointerException("cellName");
        }
        if (d.cellName.getVersion() <= 0) {
            throw new IllegalArgumentException("cellVersion");
        }
        if (d.tech == null) {
            throw new NullPointerException("tech");
        }
    }

    public CellBackup with(ImmutableCell d, long revisionDate, boolean modified, ImmutableNodeInst[] nodesArray, ImmutableArcInst[] arcsArray, ImmutableExport[] exportsArray) {
        ImmutableArrayList<ImmutableNodeInst> nodes = CellBackup.copyArray(nodesArray, this.nodes);
        ImmutableArrayList<ImmutableArcInst> arcs = CellBackup.copyArray(arcsArray, this.arcs);
        ImmutableArrayList<ImmutableExport> exports = CellBackup.copyArray(exportsArray, this.exports);
        if (this.d == d && this.revisionDate == revisionDate && this.modified == modified && this.nodes == nodes && this.arcs == arcs && this.exports == exports) {
            return this;
        }
        CellId cellId = d.cellId;
        if (this.d != d) {
            if (d.cellName == null) {
                throw new NullPointerException("cellName");
            }
            if (d.cellName.getVersion() <= 0) {
                throw new IllegalArgumentException("cellVersion");
            }
            if (d.tech == null) {
                throw new NullPointerException("tech");
            }
        }
        BitSet usedLibs = this.usedLibs;
        CellUsageInfo[] cellUsages = this.cellUsages;
        if (this.d.getVars() != d.getVars() || nodes != this.nodes || arcs != this.arcs || exports != this.exports) {
            UsageCollector uc = new UsageCollector(d, nodes, arcs, exports);
            usedLibs = uc.getLibUsages(this.usedLibs);
            cellUsages = uc.getCellUsages(cellId, this.cellUsages);
        }
        if (nodes != this.nodes && !nodes.isEmpty()) {
            boolean hasCellCenter = false;
            ImmutableNodeInst prevN = null;
            for (int i = 0; i < nodes.size(); ++i) {
                ImmutableNodeInst n = (ImmutableNodeInst)nodes.get(i);
                if (n.protoId == Generic.tech.cellCenterNode) {
                    if (hasCellCenter) {
                        throw new IllegalArgumentException("Duplicate cell center");
                    }
                    hasCellCenter = true;
                }
                if (prevN != null && TextUtils.STRING_NUMBER_ORDER.compare(prevN.name.toString(), n.name.toString()) >= 0) {
                    throw new IllegalArgumentException("nodes order");
                }
                prevN = n;
            }
        }
        int[] exportIndex = this.exportIndex;
        BitSet definedExports = this.definedExports;
        int definedExportsLength = this.definedExportsLength;
        BitSet deletedExports = this.deletedExports;
        if (exports != this.exports) {
            int exportIndexLength = 0;
            String prevExportName = null;
            for (ImmutableExport e : exports) {
                if (e.exportId.parentId != cellId) {
                    throw new IllegalArgumentException("exportId");
                }
                String exportName = e.name.toString();
                if (prevExportName != null && TextUtils.STRING_NUMBER_ORDER.compare(prevExportName, exportName) >= 0) {
                    throw new IllegalArgumentException("exportName");
                }
                prevExportName = exportName;
                int chronIndex = e.exportId.chronIndex;
                exportIndexLength = Math.max(exportIndexLength, chronIndex + 1);
            }
            exportIndex = new int[exportIndexLength];
            Arrays.fill(exportIndex, -1);
            int portIndex = 0;
            while (portIndex < exports.size()) {
                ImmutableExport e;
                e = (ImmutableExport)exports.get(portIndex);
                int chronIndex = e.exportId.chronIndex;
                if (exportIndex[chronIndex] >= 0) {
                    throw new IllegalArgumentException("exportChronIndex");
                }
                exportIndex[chronIndex] = portIndex++;
            }
            if (Arrays.equals(this.exportIndex, exportIndex)) {
                exportIndex = this.exportIndex;
            } else {
                definedExports = new BitSet();
                for (int chronIndex = 0; chronIndex < exportIndex.length; ++chronIndex) {
                    if (exportIndex[chronIndex] < 0) continue;
                    definedExports.set(chronIndex);
                }
                if ((definedExports = UsageCollector.bitSetWith(this.definedExports, definedExports)) != this.definedExports) {
                    definedExportsLength = definedExports.length();
                    deletedExports = new BitSet();
                    deletedExports.set(0, definedExportsLength);
                    deletedExports.andNot(definedExports);
                    deletedExports = UsageCollector.bitSetWith(this.deletedExports, deletedExports);
                }
            }
        }
        CellBackup backup = new CellBackup(d, revisionDate, modified, nodes, arcs, exports, usedLibs, cellUsages, exportIndex, definedExports, definedExportsLength, deletedExports);
        return backup;
    }

    private static <T> ImmutableArrayList<T> copyArray(T[] newArray, ImmutableArrayList<T> oldList) {
        return newArray != null ? new ImmutableArrayList<T>(newArray) : oldList;
    }

    CellBackup withRenamedIds(IdMapper idMapper) {
        ImmutableCell d = this.d.withRenamedIds(idMapper);
        ImmutableNodeInst[] nodesArray = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            ImmutableNodeInst oldNode = (ImmutableNodeInst)this.nodes.get(i);
            ImmutableNodeInst newNode = oldNode.withRenamedIds(idMapper);
            if (newNode != oldNode && nodesArray == null) {
                nodesArray = new ImmutableNodeInst[this.nodes.size()];
                for (int j = 0; j < i; ++j) {
                    nodesArray[j] = (ImmutableNodeInst)this.nodes.get(j);
                }
            }
            if (nodesArray == null) continue;
            nodesArray[i] = newNode;
        }
        ImmutableArcInst[] arcsArray = null;
        for (int i = 0; i < this.arcs.size(); ++i) {
            ImmutableArcInst oldArc = (ImmutableArcInst)this.arcs.get(i);
            ImmutableArcInst newArc = oldArc.withRenamedIds(idMapper);
            if (newArc != oldArc && arcsArray == null) {
                arcsArray = new ImmutableArcInst[this.arcs.size()];
                for (int j = 0; j < i; ++j) {
                    arcsArray[j] = (ImmutableArcInst)this.arcs.get(j);
                }
            }
            if (arcsArray == null) continue;
            arcsArray[i] = newArc;
        }
        ImmutableExport[] exportsArray = null;
        for (int i = 0; i < this.exports.size(); ++i) {
            ImmutableExport oldExport = (ImmutableExport)this.exports.get(i);
            ImmutableExport newExport = oldExport.withRenamedIds(idMapper);
            if (newExport != oldExport && exportsArray == null) {
                exportsArray = new ImmutableExport[this.exports.size()];
                for (int j = 0; j < i; ++j) {
                    exportsArray[j] = (ImmutableExport)this.exports.get(j);
                }
            }
            if (exportsArray == null) continue;
            exportsArray[i] = newExport;
        }
        if (this.d == d && nodesArray == null && arcsArray == null && exportsArray == null) {
            return this;
        }
        CellBackup newBackup = this.with(d, this.revisionDate, true, nodesArray, arcsArray, exportsArray);
        newBackup.check();
        return newBackup;
    }

    public ImmutableNodeInst getNode(int nodeId) {
        return nodeId < this.nodes.size() ? (ImmutableNodeInst)this.nodes.get(nodeId) : null;
    }

    public ImmutableArcInst getArc(int arcId) {
        return arcId < this.arcs.size() ? (ImmutableArcInst)this.arcs.get(arcId) : null;
    }

    public ImmutableExport getExport(ExportId exportId) {
        if (exportId.parentId != this.d.cellId) {
            throw new IllegalArgumentException();
        }
        int chronIndex = exportId.chronIndex;
        int portIndex = chronIndex < this.exportIndex.length ? this.exportIndex[chronIndex] : -1;
        return portIndex >= 0 ? (ImmutableExport)this.exports.get(portIndex) : null;
    }

    public int[] getInstCounts() {
        int l;
        for (l = this.cellUsages.length; l > 0 && (this.cellUsages[l - 1] == null || this.cellUsages[l - 1].instCount == 0); --l) {
        }
        if (l == 0) {
            return NULL_INT_ARRAY;
        }
        int[] instCounts = new int[l];
        for (int indexInParent = 0; indexInParent < l; ++indexInParent) {
            if (this.cellUsages[indexInParent] == null) continue;
            instCounts[indexInParent] = this.cellUsages[indexInParent].instCount;
        }
        return instCounts;
    }

    public int getInstCount(CellUsage u) {
        if (u.parentId != this.d.cellId) {
            throw new IllegalArgumentException();
        }
        if (u.indexInParent >= this.cellUsages.length) {
            return 0;
        }
        CellUsageInfo cui = this.cellUsages[u.indexInParent];
        if (cui == null) {
            return 0;
        }
        return cui.instCount;
    }

    public void gatherUsages(BitSet usedLibs, Map<CellId, BitSet> usedExports) {
        usedLibs.or(this.usedLibs);
        for (int indexInParent = 0; indexInParent < this.cellUsages.length; ++indexInParent) {
            CellUsageInfo cui = this.cellUsages[indexInParent];
            if (cui == null) continue;
            CellId cellId = this.d.cellId.getUsageIn((int)indexInParent).protoId;
            BitSet exports = usedExports.get(cellId);
            if (exports == null) {
                exports = new BitSet();
                usedExports.put(cellId, exports);
            }
            exports.or(cui.usedExports);
        }
    }

    void write(SnapshotWriter writer) throws IOException {
        this.d.write(writer);
        writer.writeLong(this.revisionDate);
        writer.writeBoolean(this.modified);
        writer.writeInt(this.nodes.size());
        for (ImmutableNodeInst n : this.nodes) {
            n.write(writer);
        }
        writer.writeInt(this.arcs.size());
        for (ImmutableArcInst a : this.arcs) {
            a.write(writer);
        }
        writer.writeInt(this.exports.size());
        for (ImmutableExport e : this.exports) {
            e.write(writer);
        }
    }

    static CellBackup read(SnapshotReader reader) throws IOException {
        ImmutableCell d = ImmutableCell.read(reader);
        long revisionDate = reader.readLong();
        boolean modified = reader.readBoolean();
        CellBackup backup = new CellBackup(d.withoutVariables());
        int nodesLength = reader.readInt();
        ImmutableNodeInst[] nodes = new ImmutableNodeInst[nodesLength];
        for (int i = 0; i < nodesLength; ++i) {
            nodes[i] = ImmutableNodeInst.read(reader);
        }
        int arcsLength = reader.readInt();
        ImmutableArcInst[] arcs = new ImmutableArcInst[arcsLength];
        for (int i = 0; i < arcsLength; ++i) {
            arcs[i] = ImmutableArcInst.read(reader);
        }
        int exportsLength = reader.readInt();
        ImmutableExport[] exports = new ImmutableExport[exportsLength];
        for (int i = 0; i < exportsLength; ++i) {
            exports[i] = ImmutableExport.read(reader);
        }
        backup = backup.with(d, revisionDate, modified, nodes, arcs, exports);
        return backup;
    }

    public void check() {
        this.d.check();
        this.checkVars(this.d);
        assert (this.d.cellName.getVersion() > 0);
        assert (this.d.tech != null);
        CellId cellId = this.d.cellId;
        int[] checkCellUsages = this.getInstCounts();
        boolean hasCellCenter = false;
        ArrayList<ImmutableNodeInst> nodesById = new ArrayList<ImmutableNodeInst>();
        ImmutableNodeInst prevN = null;
        for (ImmutableNodeInst n : this.nodes) {
            n.check();
            if (n.protoId == Generic.tech.cellCenterNode) {
                assert (!hasCellCenter);
                hasCellCenter = true;
            }
            this.checkVars(n);
            for (ImmutablePortInst pid : n.ports) {
                this.checkVars(pid);
            }
            while (n.nodeId >= nodesById.size()) {
                nodesById.add(null);
            }
            ImmutableNodeInst oldNode = nodesById.set(n.nodeId, n);
            assert (oldNode == null);
            if (prevN != null) assert (TextUtils.STRING_NUMBER_ORDER.compare(prevN.name.toString(), n.name.toString()) < 0);
            prevN = n;
            if (!(n.protoId instanceof CellId)) continue;
            CellId subCellId = (CellId)n.protoId;
            CellUsage u = cellId.getUsageIn(subCellId);
            int n2 = u.indexInParent;
            checkCellUsages[n2] = checkCellUsages[n2] - 1;
            assert (this.cellUsages[u.indexInParent] != null);
            for (int j = 0; j < n.ports.length; ++j) {
                ImmutablePortInst pid = n.ports[j];
                if (pid == ImmutablePortInst.EMPTY) continue;
                this.checkPortInst(n, subCellId.getPortId(j));
            }
        }
        for (int i = 0; i < checkCellUsages.length; ++i) {
            assert (checkCellUsages[i] == 0);
        }
        BitSet arcIds = new BitSet();
        ImmutableArcInst prevA = null;
        for (ImmutableArcInst a : this.arcs) {
            assert (!arcIds.get(a.arcId));
            arcIds.set(a.arcId);
            if (prevA != null) {
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(prevA.name.toString(), a.name.toString());
                assert (cmp <= 0);
                if (cmp == 0) {
                    assert (!a.name.isTempname());
                    assert (prevA.arcId < a.arcId);
                }
            }
            prevA = a;
            a.check();
            this.checkVars(a);
            this.checkPortInst((ImmutableNodeInst)nodesById.get(a.tailNodeId), a.tailPortId);
            this.checkPortInst((ImmutableNodeInst)nodesById.get(a.headNodeId), a.headPortId);
        }
        if (this.exportIndex.length > 0) assert (this.exportIndex[this.exportIndex.length - 1] >= 0);
        assert (this.exportIndex.length == this.definedExportsLength);
        assert (this.definedExports.length() == this.definedExportsLength);
        for (int i = 0; i < this.exports.size(); ++i) {
            ImmutableExport e = (ImmutableExport)this.exports.get(i);
            e.check();
            this.checkVars(e);
            assert (e.exportId.parentId == cellId);
            assert (this.exportIndex[e.exportId.chronIndex] == i);
            if (i > 0) assert (TextUtils.STRING_NUMBER_ORDER.compare(((ImmutableExport)this.exports.get((int)(i - 1))).name.toString(), e.name.toString()) < 0) : i;
            this.checkPortInst((ImmutableNodeInst)nodesById.get(e.originalNodeId), e.originalPortId);
        }
        int exportCount = 0;
        for (int chronIndex = 0; chronIndex < this.exportIndex.length; ++chronIndex) {
            int portIndex = this.exportIndex[chronIndex];
            if (portIndex == -1) {
                assert (!this.definedExports.get(chronIndex));
                continue;
            }
            assert (this.definedExports.get(chronIndex));
            ++exportCount;
            assert (((ImmutableExport)this.exports.get((int)portIndex)).exportId.chronIndex == chronIndex);
        }
        assert (this.exports.size() == exportCount);
        BitSet checkDeleted = new BitSet();
        checkDeleted.set(0, this.definedExportsLength);
        checkDeleted.andNot(this.definedExports);
        assert (this.deletedExports.equals(checkDeleted));
        if (this.definedExports.isEmpty()) assert (this.definedExports == UsageCollector.EMPTY_BITSET);
        if (this.deletedExports.isEmpty()) assert (this.deletedExports == UsageCollector.EMPTY_BITSET);
        if (this.usedLibs.isEmpty()) assert (this.usedLibs == UsageCollector.EMPTY_BITSET);
        for (CellUsageInfo cui : this.cellUsages) {
            if (cui == null) continue;
            cui.check();
        }
    }

    private void checkVars(ImmutableElectricObject d) {
        for (Variable var : d.getVars()) {
            Object o = var.getObject();
            if (o instanceof Object[]) {
                Object[] a;
                for (Object e : a = (Object[])o) {
                    this.checkVarObj(e);
                }
                continue;
            }
            this.checkVarObj(o);
        }
    }

    private void checkVarObj(Object o) {
        if (o instanceof LibId) {
            int libIndex = ((LibId)o).libIndex;
            assert (this.usedLibs.get(libIndex));
        } else if (o instanceof CellId) {
            CellUsage u = this.d.cellId.getUsageIn((CellId)o);
            assert (this.cellUsages[u.indexInParent] != null);
        } else if (o instanceof ExportId) {
            this.checkExportId((ExportId)o);
        }
    }

    private void checkPortInst(ImmutableNodeInst node, PortProtoId portId) {
        assert (node != null);
        assert (portId.getParentId() == node.protoId);
        if (portId instanceof ExportId) {
            this.checkExportId((ExportId)portId);
        }
    }

    private void checkExportId(ExportId exportId) {
        CellUsage u = this.d.cellId.getUsageIn(exportId.parentId);
        assert (this.cellUsages[u.indexInParent].usedExports.get(exportId.getChronIndex()));
    }

    public boolean sameExports(CellBackup thatBackup) {
        if (thatBackup == this) {
            return true;
        }
        if (this.exports.size() != thatBackup.exports.size()) {
            return false;
        }
        for (int i = 0; i < this.exports.size(); ++i) {
            if (((ImmutableExport)this.exports.get((int)i)).exportId == ((ImmutableExport)thatBackup.exports.get((int)i)).exportId) continue;
            return false;
        }
        return true;
    }

    static class CellUsageInfo {
        final int instCount;
        final BitSet usedExports;
        final int usedExportsLength;

        CellUsageInfo(int instCount, BitSet usedExports) {
            this.instCount = instCount;
            this.usedExportsLength = usedExports.length();
            this.usedExports = this.usedExportsLength > 0 ? usedExports : UsageCollector.EMPTY_BITSET;
        }

        CellUsageInfo with(int instCount, BitSet usedExports) {
            usedExports = UsageCollector.bitSetWith(this.usedExports, usedExports);
            if (this.instCount == instCount && this.usedExports == usedExports) {
                return this;
            }
            return new CellUsageInfo(instCount, usedExports);
        }

        void checkUsage(CellBackup subCellBackup) {
            if (subCellBackup == null) {
                throw new IllegalArgumentException("subCell deleted");
            }
            if (subCellBackup.definedExportsLength < this.usedExportsLength || subCellBackup.deletedExports.intersects(this.usedExports)) {
                throw new IllegalArgumentException("exportUsages");
            }
        }

        private void check() {
            assert (this.instCount >= 0);
            assert (this.usedExportsLength == this.usedExports.length());
            if (this.usedExportsLength == 0) assert (this.usedExports == UsageCollector.EMPTY_BITSET);
        }
    }
}

