NAME
    ARM --perl module to disassemble an arm instruction.

SYNOPSIS
        use Arm;
        $mnemonic = disassemble($instr, $addr_of_instr);


DESCRIPTION
    This module provides a perl interface to
    `Debugger_Dissassemble', allowing numeric ARM instructions to be
    disassembled to text mnemonics. It is necessary to supply the
    address of the instruction to correctly disassemble `PC'
    relative instructions (*i.e.* `B', `BL', `LDR *x*,[PC,#..]' - if
    this is omitted it will default to zero.

    Returns the textual mnemonic, or undefined on error.

BUGS
    It is limited by the capabilities of the Debugger in the version
    of RISC OS it is running under. For example 32 bit ARM
    instructions will not be recognised on an A series machine.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

