package jBilling::Client::SOAP;

use 5.010;
use strict;
use warnings FATAL => 'all';
use jBilling::Client::SOAP::API;
use jBilling::Client::SOAP::OrderWS;
use jBilling::Client::SOAP::OrderLineWS;
use jBilling::Client::SOAP::MetaFieldValueWS;
use jBilling::Client::SOAP::ItemDTOEx;
use jBilling::Client::SOAP::ItemTypeWS;
use jBilling::Client::SOAP::PriceModelWS;
use jBilling::Client::SOAP::Exception;
use Scalar::Util qw(looks_like_number);

our $VERSION =  0.05;
my $API;

sub getAPI {
    # Expects a hash containing URL, Username and Password
    my $self = shift;
    my %args = @_;
    $self->{'API'} = jBilling::Client::SOAP::API->new( %args );
    
}

sub new {
    my $class = shift;
    my $self  = {};
    bless( $self, $class );
	return $self;
}

sub createOrder {
    my $self = shift;
    my $orderWS = shift;
    
	# Pass the Order through to the API
	my $response = $self->{'API'}->createOrder(
	    SOAP::Data->value($orderWS));
	return $response->valueof('//return');
    
}

sub createUpdateOrder {
    my $self = shift;
    my $orderWS = shift;
    
	# Pass the Order through to the API
	my $response = $self->{'API'}->createUpdateOrder(
	    SOAP::Data->value($orderWS));
	return $response->valueof('//return');
    
}

sub getOrder {
    my $self    = shift;
    my $orderId = shift;
    my $response = $self->{'API'}->getOrder(
	SOAP::Data->new( name => 'arg0', value => $orderId, type => 'xsd:int' )
    );
    
    my $order = jBilling::Client::SOAP::OrderWS->new();
    # Populate a new OrderWS Object
    $order->load($response->valueof('//return'));
    return $order;
}

sub getAllItems {
    my $self = shift;
    my @items;
    
    my $response = $self->{'API'}->getAllItems();
    print $response->valueof('//return');
}

sub getItemByCategory {
    my $self = shift;
    my $type_id = shift;
    my @items;
    
    my $response = $self->{'API'}->getItemByCategory(
			SOAP::Data->new( name => 'arg0', value => $type_id, type => 'xsd:int' )
			);
    my @returned = $response->valueof('//return');
    foreach (@returned){
	my $itemDTOEx = jBilling::Client::SOAP::ItemDTOEx->new();
	$itemDTOEx->load(\%{$_});
	push @items, $itemDTOEx;
    }
    return @items;
}

sub updateOrderLine {
    my $self = shift;
    my @data = @_;
    
    my $response = $self->{'API'}->updateOrderLine(
			SOAP::Data->new( name => 'arg0', value => \@data )
			);
}

1;

=pod

=head1 NAME

jBilling::Client::SOAP - Communicate with jBilling

=head1 VERSION

Version 0.05

=head1 SYNOPSIS

This module acts as an interface for functionality exposed by the
jBilling SOAP API.  

=head2 Initialise the library
    use jBilling::Client::SOAP;
    my $jb = jBilling::Client::SOAP->new();
	$jb->getAPI(
	    'username' => 'yourusername',
	    'password' => 'yourpassword',
	    'url'      => 'http://yourservername:yourserverport/jbilling/services/api'
	);    # Initialise the API

=head2 Load an existing order from jBilling
    my $order = jBilling::Client::SOAP::OrderWS->new(
        'jbilling' => $jb,     # The Client connection to jBilling
        'id'       => 25300    # Specify the ID which we want to load
    )->retrieve;               # Retrieve the order details from jBilling 

=head2 Create a new order
    my $newOrder = jBilling::Client::SOAP::OrderWS->new('jbilling' => $jb,
                                                        'period' => '200',
                                                        'billingTypeId' => '2',
                                                        'currencyId' => '110',
                                                        'userId' => '122',
                                                        'activeSince' => '2015-01-31',
                                                        'notes' => 'Some Order notes from the API');
    
    # Create some OrderLines
    my $ol = jBilling::Client::SOAP::OrderLineWS->new('useItem' => 'true',
                                                      'itemId' => 2103, # MAKE SURE THIS ITEM MATCHES AN ITEM YOUR SYSTEM!
                                                      'typeId' => 1, # Item
                                                      'quantity' =>  1,
                                                      'description' => "test from perl api",
                                                      );
    my $ol1 = jBilling::Client::SOAP::OrderLineWS->new('useItem'    => 'true',
                                                       'itemId'     => '2102', # MAKE SURE THIS ITEM MATCHES AN ITEM YOUR SYSTEM!
                                                       'typeId'     => 1, # Item
                                                       'quantity'   => 1,
                                                       'description' => "Another test from perl api"
                                                       );
    # And some Metafields
    my $retailer = jBilling::Client::SOAP::MetaFieldValueWS->new(
            'fieldName'   => 'retailer',
            'stringValue' => 'Test Retailer',
    );
    my $orderno = jBilling::Client::SOAP::MetaFieldValueWS->new(
            'fieldName'   => 'Order Number',
            'stringValue' => 'TestOrderNo'
    );
    
    # add our order lines to the order
    $newOrder->orderLines(\@OrderLines);
    $newOrder->metaFields(\@metafields);
    $newOrder->save; # Returns orderId on success

=head1 SUBROUTINES/METHODS

=head2 getAPI

This method initiates a SOAP::Lite object for later re-use

=head2 new

Constructs the jBilling::Client::SOAP object

=cut
